/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin.mtmt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.Event;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.invites.InviteGameEndedEvent;
import net.zomis.minesweeper.events.invites.InviteGameStartingEvent;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.events.player.PlayerLoginEvent;
import net.zomis.plugin.mtmt.MataMata;

public class MataMataPlugin
extends MinesweeperPlugin
implements EventListener {
    private static List<MataMata> mtmts = new ArrayList<MataMata>();

    private boolean playerIsMtmtCreator(MinesweeperPlayer player) {
        return this.getMtmtWithCreator(player) != null;
    }

    private MataMata getMtmtWithCreator(MinesweeperPlayer player) {
        for (MataMata mtmt : new ArrayList<MataMata>(mtmts)) {
            if (mtmt == null || !mtmt.getCreator().equals(player)) continue;
            return mtmt;
        }
        return null;
    }

    @Event
    public void mtmtNotify(PlayerLoginEvent event) {
        for (MataMata mtmt : mtmts) {
            if (!mtmt.isOpenForInvites()) continue;
            event.getPlayer().sendChat(mtmt + " is open for inscriptions! Write '/mtmt join' to join!");
        }
    }

    @Command(command="mtest", help="Test Mata-Mata tournaments", requiredPermission="ADMIN")
    public void mtmtTestCommand(PlayerCommandEvent event) throws InterruptedException {
        List ais = event.getPlayer().getServer().getAIs();
        Collections.shuffle(ais);
        event.getPlayer().getServer().broadcastChat("The AIs decided to make a mata-mata!");
        this.mtmtCommand(new PlayerCommandEvent((MinesweeperPlayer)ais.get(0), "mtmt new"));
        for (MinesweeperPlayer player : ais) {
            this.mtmtCommand(new PlayerCommandEvent(player, "mtmt join"));
        }
        for (String param : event.getParameters()) {
            MinesweeperPlayer player = event.getPlayer().getServer().getPlayerByName(param);
            if (player == null) continue;
            this.mtmtCommand(new PlayerCommandEvent(player, "mtmt join"));
        }
        String format = "Players have %d seconds to join the Mata-Mata! To join the mata-mata, write '/mtmt join'";
        event.getPlayer().getServer().broadcastChat(String.format(format, 30));
        Thread.sleep(15000L);
        event.getPlayer().getServer().broadcastChat(String.format(format, 15));
        Thread.sleep(5000L);
        event.getPlayer().getServer().broadcastChat(String.format(format, 10));
        Thread.sleep(5000L);
        event.getPlayer().getServer().broadcastChat(String.format(format, 5));
        Thread.sleep(2000L);
        event.getPlayer().getServer().broadcastChat(String.format(format, 3));
        Thread.sleep(1000L);
        event.getPlayer().getServer().broadcastChat(String.format(format, 2));
        Thread.sleep(1000L);
        event.getPlayer().getServer().broadcastChat(String.format(format, 1));
        Thread.sleep(1000L);
        this.mtmtCommand(new PlayerCommandEvent((MinesweeperPlayer)ais.get(0), "mtmt start"));
    }

    @Command(command="mtmt", help="Mata-Mata tournament command")
    public void mtmtCommand(PlayerCommandEvent event) {
        String param = event.getParameter(0);
        event.getPlayer().sendChat("slash-mtmt: " + param);
        if (param.contentEquals("new")) {
            if (this.playerIsMtmtCreator(event.getPlayer())) {
                event.getPlayer().sendChat("You have an old mtmt running. Please write '/mtmt cancel' if you want to end it.");
                return;
            }
            MataMata mtmt = new MataMata(event.getPlayer());
            mtmts.add(mtmt);
            event.getPlayer().getServer().broadcastChat("Mata-Mata is now open for inscriptions, started by " + event.getPlayer().getDisplayName());
            event.getPlayer().getServer().broadcastChat(String.format("%s joins %s", event.getPlayer().getDisplayName(), mtmt));
            event.getPlayer().getServer().broadcastChat("To join the mata-mata tournament, write '/mtmt join'");
        } else if (param.contentEquals("clean")) {
            for (MataMata mtmt : new ArrayList<MataMata>(mtmts)) {
                if (!mtmt.isEnded()) continue;
                mtmts.remove(mtmt);
            }
        } else if (param.contentEquals("clearall")) {
            for (MataMata mtmt : new ArrayList<MataMata>(mtmts)) {
                mtmt.cancel();
            }
            mtmts.clear();
        } else if (param.contentEquals("join")) {
            for (MataMata mtmt : mtmts) {
                if (!mtmt.isOpenForInvites()) continue;
                if (mtmt.playerJoin(event.getPlayer())) {
                    event.getPlayer().getServer().broadcastChat(String.format("%s joins %s", event.getPlayer().getDisplayName(), mtmt));
                } else {
                    event.getPlayer().sendChat("You have already signed up for " + mtmt);
                }
                return;
            }
            event.getPlayer().sendChat("There are no open Mata-Mata tournaments for you to join.");
        } else if (param.contentEquals("WO")) {
            MinesweeperPlayer player = event.getPlayer().getServer().getPlayerByName(event.getParameter(1));
            if (player == null) {
                event.getPlayer().sendChat("Player not found: " + event.getParameter(1));
                return;
            }
            for (MataMata mtmt : mtmts) {
                if (event.getPlayer().equals(mtmt.getCreator())) {
                    mtmt.walkover(player);
                }
                event.getPlayer().sendChat(player.getDisplayName() + " has been removed from " + mtmt);
            }
        } else if (param.contentEquals("add")) {
            for (MataMata mtmt : mtmts) {
                if (!event.getPlayer().equals(mtmt.getCreator())) continue;
                MinesweeperPlayer player = event.getPlayer().getServer().getPlayerByName(event.getParameter(1));
                if (player == null || !player.isOnline()) {
                    event.getPlayer().sendChat("Player not found: " + event.getParameter(1));
                    return;
                }
                if (mtmt.playerJoin(player)) {
                    event.getPlayer().getServer().broadcastChat(String.format("%s joins %s (added by %s)", player.getDisplayName(), mtmt, event.getPlayer().getDisplayName()));
                } else {
                    event.getPlayer().sendChat(player.getDisplayName() + " is already signed up for " + mtmt);
                }
                return;
            }
            event.getPlayer().sendChat("There are no open Mata-Mata tournaments for you to join.");
        } else if (param.contentEquals("cancel")) {
            MataMata mtmt = this.getMtmtWithCreator(event.getPlayer());
            if (mtmt == null) {
                return;
            }
            mtmt.cancel();
            mtmts.remove(mtmt);
        } else if (param.contentEquals("start")) {
            for (MataMata mtmt : mtmts) {
                if (!event.getPlayer().equals(mtmt.getCreator())) continue;
                mtmt.start();
                return;
            }
            event.getPlayer().sendChat("There are no open Mata-Mata tournaments for you to start.");
        } else {
            event.getPlayer().sendChat("Current Mata-Matas:");
            for (MataMata mtmt : mtmts) {
                mtmt.sendInfo(event.getPlayer());
            }
        }
    }

    @Event
    public void onGameEnd(InviteGameEndedEvent event) {
        for (MataMata mtmt : mtmts) {
            if (mtmt.isEnded()) continue;
            mtmt.informGameEnd(event.getGame());
        }
    }

    @Event
    public void onGameStart(InviteGameStartingEvent event) {
        for (MataMata mtmt : mtmts) {
            if (mtmt.isEnded()) continue;
            mtmt.informGameStart(event);
        }
    }

    public boolean canBeChosenBy(MinesweeperPlayer arg0) {
        return false;
    }

    public void onDisable() {
    }

    public void onEnable() {
        this.registerListener(this);
    }
}

