/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.commands;

import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;

public class LoadSaveMapPlugin
extends MinesweeperPlugin
implements EventListener {
    @Command(command="save", help="Save map as string", requiredPermission="ADMIN")
    public void onSave(PlayerCommandEvent event) {
        event.getPlayer().sendChat(event.getMap().saveMap());
    }

    @Command(command="load", help="Load map from string", requiredPermission="ADMIN")
    public void onLoad(PlayerCommandEvent event) {
        if (event.getParameters().length > 1) {
            event.getMap().setMinePositions(event.getParameter(0));
            event.getGame().performClicks(event.getParameter(1));
        } else {
            event.getMap().loadMap(event.getParameter(0));
        }
        event.getMap().setCurrentPlayerTurn(0);
    }

    @Command(command="nextturn", help="Next turn", requiredPermission="ADMIN")
    public void onNextTurn(PlayerCommandEvent event) {
        event.getMap().nextTurn();
    }

    @Command(command="clicks", help="Perform clicks from string", requiredPermission="ADMIN")
    public void onClicks(PlayerCommandEvent event) {
        event.getGame().performClicks(event.getParameter(0));
        event.getMap().setCurrentPlayerTurn(0);
    }

    @Command(command="mclear", help="Clear map", requiredPermission="ADMIN")
    public void onClearMap(PlayerCommandEvent event) {
        event.getMap().clear();
        event.getMap().setCurrentPlayerTurn(0);
    }

    @Command(command="mines", help="Set minepositions from string", requiredPermission="ADMIN")
    public void onMines(PlayerCommandEvent event) {
        event.getPlayer().getGame().setMinePositions(event.getParameter(0));
    }

    public boolean canBeChosenBy(MinesweeperPlayer arg0) {
        return false;
    }

    public void onDisable() {
    }

    public void onEnable() {
        this.registerListener(this);
    }
}

