/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin.nonstandard;

import java.util.ArrayList;
import java.util.Collection;
import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.weapons.BaseWeapon;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public class SizedBombWeapon
extends BaseWeapon {
    private final int bombSize;
    private final int boardSize;
    public static final int USE_COUNT = 1;
    protected int hasUsed = 0;

    public SizedBombWeapon(int size, int boardSize) {
        this.bombSize = size;
        this.boardSize = boardSize;
    }

    public int getUseCount() {
        return this.hasUsed;
    }

    public String getWeaponType() {
        return "B";
    }

    public boolean canUseAt(MinesweeperPlayingPlayer user, MinesweeperField field) {
        Collection<MinesweeperField> affected = this.getFieldsAffected(user, field);
        if (affected == null) {
            return false;
        }
        return affected.size() > 0;
    }

    protected MinesweeperField getMove(MinesweeperPlayingPlayer user, MinesweeperField field) {
        int edgeX = (field.getMap().getFieldWidth() - this.boardSize) / 2;
        int edgeY = (field.getMap().getFieldHeight() - this.boardSize) / 2;
        int xpos = UtilZomisUtils.ensureRange((int)(edgeX + this.getRangeDown()), (int)field.getX(), (int)(field.getMap().getFieldWidth() - edgeX - this.getRangeUp() - 1));
        int ypos = UtilZomisUtils.ensureRange((int)(edgeY + this.getRangeDown()), (int)field.getY(), (int)(field.getMap().getFieldHeight() - edgeY - this.getRangeUp() - 1));
        return field.getMap().getPosition(xpos, ypos);
    }

    private int getRangeDown() {
        return (this.bombSize - 1) / 2;
    }

    private int getRangeUp() {
        return (int)Math.floor((double)this.bombSize / 2.0);
    }

    public Collection<MinesweeperField> getFieldsAffected(MinesweeperPlayingPlayer user, MinesweeperField field) {
        field = this.getMove(user, field);
        ArrayList<MinesweeperField> result = new ArrayList<MinesweeperField>();
        for (MinesweeperField mf : this.getFieldsWithinRange(field, this.getRangeDown(), this.getRangeUp())) {
            if (mf.isClicked()) continue;
            result.add(mf);
        }
        return result;
    }

    private final Collection<MinesweeperField> getFieldsWithinRange(MinesweeperField field, int rangeDown, int rangeUp) {
        ArrayList<MinesweeperField> result = new ArrayList<MinesweeperField>();
        for (int x = -rangeDown; x <= rangeUp; ++x) {
            for (int y = -rangeDown; y <= rangeUp; ++y) {
                MinesweeperField mf = field.getMap().getPosition(field.getX() + x, field.getY() + y);
                if (mf == null) continue;
                result.add(mf);
            }
        }
        return result;
    }

    public boolean canUse(MinesweeperPlayingPlayer user) {
        if (user.hasMostScore()) {
            return false;
        }
        return this.hasUsed < 1;
    }

    public boolean useAt(MinesweeperMove moveInfo) {
        if (!this.canUseAt(moveInfo.getPlayer(), moveInfo.getMovePosition())) {
            return false;
        }
        MinesweeperMove move = moveInfo.getPlayer().createMove((MinesweeperWeapon)this, this.getMove(moveInfo.getPlayer(), moveInfo.getMovePosition()));
        for (MinesweeperField mf : this.getFieldsAffected(moveInfo.getPlayer(), move.getMovePosition())) {
            this.expanderOpen(mf, move);
        }
        ++this.hasUsed;
        moveInfo.getMap().nextTurn();
        return true;
    }

    public void resetUsage() {
        this.hasUsed = 0;
    }

    public String toString() {
        return (this.hasUsed == 0 ? "Unused " : "USED ") + super.toString();
    }
}

