/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin.global;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.Event;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.game.GameEndedEvent;
import net.zomis.minesweeper.events.invites.InviteGameEndedEvent;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.events.player.PlayerLoginEvent;
import net.zomis.minesweeper.game.GameTag;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.plugin.global.DonutHandler;

public class GlobalPlugin
extends MinesweeperPlugin
implements EventListener {
    private Random random = new Random();

    @Event
    public void aiInviteOnGameEnd(InviteGameEndedEvent event) {
        if (event.getGame().getPlayingPlayers().size() != 2) {
            return;
        }
        int ais = 0;
        for (MinesweeperPlayingPlayer pp : event.getGame().getPlayingPlayers()) {
            if (!pp.isAI()) continue;
            ++ais;
        }
        if (ais == 1 && this.random.nextBoolean()) {
            MinesweeperPlayer ai = null;
            MinesweeperPlayer human = null;
            for (MinesweeperPlayer pp : event.getGame().getPlayers()) {
                if (!pp.isAI()) continue;
                ai = pp;
                break;
            }
            for (MinesweeperPlayer pp : event.getGame().getPlayers()) {
                if (pp.isAI()) continue;
                human = pp;
                break;
            }
            List plugins = event.getGame().getActivePlugins();
            ArrayList<String> plugs = new ArrayList<String>(plugins.size());
            for (MinesweeperPlugin plugin : plugins) {
                plugs.add(plugin.getSimpleName());
            }
            ai.createInvitation(plugs.toArray(new String[plugs.size()])).autostart().sendInvite(human);
        }
    }

    @Command(command="delay", help="Check or change the AI delay in the game", requiredPermission="DONATOR")
    public void delay(PlayerCommandEvent event) {
        event.getGame().sendChatMessage(event.getServer().getServerPlayer(), "Current AI delay is " + event.getGame().getAIDelay());
        int delay = event.getParameterInt(0, -1);
        if (delay != -1 && delay < 10000) {
            event.getGame().setAIDelay(delay);
            event.getGame().sendChatMessage(event.getServer().getServerPlayer(), "Changed AI delay to " + delay);
        }
    }

    @Command(command="tag", help="/tag (tagname) (optional: parameter) -- Add a tag in the beginning of a game which will make it easier to find later. See http://stats.minesweeperflags.net/tags?tagtype=before for a list of available tags")
    public void tagCommand(PlayerCommandEvent event) {
        if (event.getGame() == null) {
            event.getPlayer().sendChatBy("You may only use the /tag-command while playing a game", event.getServer().getServerPlayer());
            return;
        }
        if (event.getPlayer().getPlayingGame() == event.getGame()) {
            MinesweeperGame game = event.getGame();
            if (game.getClickCount() > 10) {
                event.getPlayer().sendChatBy("Too late to add tags to this game. Tags can only be added during the first 10 moves", event.getServer().getServerPlayer());
                return;
            }
            try {
                int param = Integer.parseInt(event.getParameter(1));
                event.getGame().addTag(new GameTag(GameTag.TagType.BEFORE, event.getGame(), event.getParameter(0), Integer.valueOf(param), event.getPlayer()));
            }
            catch (NumberFormatException e) {
                event.getGame().addTag(new GameTag(GameTag.TagType.BEFORE, event.getGame(), event.getParameter(0), null, event.getPlayer()));
            }
        } else {
            event.getPlayer().sendChatBy("You may only use the /tag-command while playing a game", event.getServer().getServerPlayer());
        }
    }

    @Event
    public void onPlayerLogin(PlayerLoginEvent event) {
        event.getPlayer().sendChat("Welcome to Minesweeper Flags Extreme! To see a list of commands, write /help in the chat.");
        if (!event.getPlayer().getServer().hasDatabaseConnection()) {
            event.getPlayer().sendChat("The server currently does not have a database connection. Games that you play will NOT be stored in the database and cannot be resumed if all players leave the game.", Integer.valueOf(0xFF8080));
        }
    }

    @Command(command="brasil", help="Instructions in portuguese")
    public void onBrasil(PlayerCommandEvent event) {
        event.getPlayer().sendChat("Duplo click em qualquer jogador, ou selecione ele e pressione a tecla de desafio ('Invite'), para convid\ufffd-lo a jogar com voc\ufffd");
        event.getPlayer().sendChat("use o bot\ufffdo 'jogar com qualquer pessoa' ('Play with anyone') se voc\ufffd n\ufffdo se interessar com quem vai jogar. Voc\ufffd ficar\ufffd emparelhado com o pr\ufffdximo que pressionar esse but\ufffdo, quem quer que seja.");
        event.getPlayer().sendChat("Se voc\ufffd quiser ficar no chat, mas n\ufffdo quiser jogar, voc\ufffd pode acionar o 'rejeitar automaticamente qualquer convite' (Auto-Reject any play requests). Isso ir\ufffd rejeitar automaticamente qualquer convite que voc\ufffd tenha recebido");
        event.getPlayer().sendChat("Qualquer jogo marcado com asterisco na lista pode ser continuado a partir de um duplo- clique no jogo");
        event.getPlayer().sendChat("N\ufffdo desista se seu advers\ufffdrio n\ufffdo joga! Se seu advers\ufffdrio nao jogar em tr\ufffds dias voc\ufffd vencer\ufffd!");
    }

    @Command(command="g", help="See what the server sees. Inside game only.", requiredPermission="ADMIN")
    public void onSeeBoard(PlayerCommandEvent event) {
        if (event.getPlayer().isInGame()) {
            MinesweeperGame game = event.getPlayer().getGame();
            if (game == null) {
                return;
            }
            for (MinesweeperPlayingPlayer player : game.getPlayingPlayers()) {
                event.getPlayer().sendChat("Player " + player.getIndex() + ": " + player.getName() + " (" + player.getScore() + ")");
            }
            String str = "";
            for (MinesweeperField mf : game.getIteration()) {
                if (mf.getX() == 0) {
                    event.getPlayer().sendChat(str);
                    str = "";
                }
                str = str + (mf.isClicked() ? (mf.isMine() ? "*" : Integer.valueOf(mf.getValue())) : " ");
            }
            event.getPlayer().sendChat(str);
            event.getPlayer().sendChat("Mines left: " + game.getMinesLeft());
        }
    }

    @Command(command="bubu", help="The good old bubu-command.")
    public void onServerBubu(PlayerCommandEvent event) {
        if (!event.getPlayer().isServer()) {
            event.getPlayer().getServer().broadcastChat(event.getPlayer().getName() + " used the BUBU-command. Although it has no boolean yet, it's just here because Minken wants it - whatever it does.");
            return;
        }
        event.getPlayer().getServer().broadcastChat("#Server is bubuing all day long!");
    }

    @Command(command="say", help="")
    public void onServerSay(PlayerCommandEvent event) {
        if (!event.getPlayer().isServer()) {
            return;
        }
        event.getPlayer().getServer().broadcastChat(event.getFullCommand());
    }

    @Command(command="me", help="Do something", requiredPermission="TESTER")
    public void command_me(PlayerCommandEvent event) {
        String mess = event.getPlayer().getName() + " " + event.getFullCommand();
        event.getPlayer().getServer().broadcastChat(mess);
    }

    @Event
    public void onGameEnded(GameEndedEvent event) {
        if (event.getGame() != null) {
            return;
        }
        List players = event.getMap().getPlayingPlayers();
        String str = "Game " + event.getGame().getGameID() + " has ended. ";
        String playerString = "";
        for (MinesweeperPlayingPlayer player : players) {
            if (!playerString.isEmpty()) {
                playerString = playerString + ", ";
            }
            playerString = playerString + player.getName() + " (" + player.getScore() + ")";
        }
        event.getGame().getServer().broadcastChat(str + playerString);
    }

    public void onDisable() {
    }

    public void onEnable() {
        this.registerListener(this);
        this.registerListener(new DonutHandler());
    }

    public boolean canBeChosenBy(MinesweeperPlayer arg0) {
        return false;
    }
}

