package net.zomis.plugin.twovstwo;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.classic.DefaultExpanderRule;
import net.zomis.minesweeper.classic.EndShowMines;
import net.zomis.minesweeper.classic.StandardNeighbors;
import net.zomis.minesweeper.events.Event;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.game.FieldActivatedEvent;
import net.zomis.minesweeper.events.game.GameInitEvent;
import net.zomis.minesweeper.events.game.PlayerEliminateCheckEvent;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.weapons.classic.ClickWeapon;

public class TwoVsTwo extends MinesweeperPlugin implements EventListener {
	@Event
	public void onGameInit(GameInitEvent event) {
		for (MinesweeperPlayingPlayer player : event.getMap().getPlayingPlayers()) {
			player.giveWeapon(new ClickWeapon());
			player.giveWeapon(new Mfe2vs2Bomb());
		}
	}
	
	@Event
	public void onFieldActivated(FieldActivatedEvent event) {
		if (event.getField() == null) return;
		
		if (!event.getField().isMine()) return;
		
		MinesweeperPlayingPlayer player = event.getPlayingPlayer();
		if (player == null) return;
		
		if (player.getIndex() >= NUM_TEAMS) {
			event.getField().activate(event.getMap().getPlayingPlayers().get(player.getIndex() % 2));
			event.getField().sendInfoToPlayers();
		}
	}
	
	private static final int NUM_TEAMS = 2;
	
	public static Map<Integer, Integer> getTeamScores(MinesweeperMap map) {
		Map<Integer, Integer> teamScores = new HashMap<Integer, Integer>();
		for (int i = 0; i < NUM_TEAMS; i++) teamScores.put(i, 0);
		
		for (MinesweeperPlayingPlayer pp : map.getPlayingPlayers()) {
			teamScores.put(getTeam(pp), teamScores.get(getTeam(pp)) + pp.getScore());
		}
		return teamScores;
	}
	
	public static int getTeam(MinesweeperPlayingPlayer pp) {
		return pp.getIndex() % NUM_TEAMS;
	}
	
	@Event
	public void onElimination(PlayerEliminateCheckEvent event) {
		event.setCancelled(true); // Disable the default elimination
		
		Map<Integer, Integer> teamScores = getTeamScores(event.getMap());
		for (Entry<Integer, Integer> ee : teamScores.entrySet()) {
			if (ee.getValue() >= event.getMap().getMinesCount() / 2.0) {
				// We have a winning team!
				for (MinesweeperPlayingPlayer pp : event.getMap().getPlayingPlayers()) {
					if (getTeam(pp) != ee.getKey() && !pp.isEliminated()) pp.eliminateLoss();
				}
				if (event.getGame() != null)
					event.getGame().sendChatMessage("Team " + event.getMap().getPlayingPlayers().get(ee.getKey()).getName() + " won with a total of " + ee.getValue());
				
				// Even though a player should actually be the winner, he has to be eliminated for the game to end.
				for (MinesweeperPlayingPlayer pp : event.getMap().getPlayingPlayers()) {
					if (pp.getIndex() >= NUM_TEAMS) pp.eliminateLoss();
				}
			}
		}
	}
	
	@Override
	public void onDisable() {
	}

	@Override
	public void onEnable() {
		this.registerListener(this);
		this.registerListener(new StandardNeighbors());
		this.registerListener(new DefaultExpanderRule());
		this.registerListener(new EndShowMines());
	}

	@Override
	public boolean canBeChosenBy(MinesweeperPlayer user) {
		return true;
	}
}
