package net.zomis.plugin.twovstwo;

import java.util.Map;
import java.util.Map.Entry;

import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.weapons.classic.BombWeapon;

public class Mfe2vs2Bomb extends BombWeapon {
	@Override
	public boolean canUse(MinesweeperPlayingPlayer player) {
		Map<Integer, Integer> scores = TwoVsTwo.getTeamScores(player.getMap());
		int team = TwoVsTwo.getTeam(player);
		
		for (Entry<Integer, Integer> ee : scores.entrySet()) {
			if (ee.getValue() == null) throw new AssertionError("ee value is null for key " + ee.getKey());
			if (team > 1) throw new AssertionError("team is " + team);
			if (scores.get(team) == null) throw new AssertionError("team score is null: " + team);
			
			if (ee.getValue() > scores.get(team)) {
				// We have found a team that has a higher score than the current team!
				return super.canUse(player); // Perform the check if we have already used the bomb or not.
			}
		}
		
		return false;
	}
}
