package net.zomis.plugin.nonstandard;

import net.zomis.minesweeper.events.Event;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.game.GameInitEvent;
import net.zomis.minesweeper.events.game.GamePreGenerateEvent;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.weapons.classic.ClickWeapon;

public class SmallerBoard implements EventListener {
	
	public SmallerBoard(int size) {
		this.size = size;
	}

	private final int size;
	
	@Event
	public void onPreGenerateGame(GamePreGenerateEvent event) {
		this.fixMap(event.getMap());
	}
	private void fixMap(MinesweeperMap map) {
		for (int xx = 0; xx < map.getFieldWidth() - size; xx++) {
			int xcol = xx % 2 == 0 ? xx / 2 : map.getFieldWidth() - xx / 2 - 1;
			for (int yy = 0; yy < map.getFieldHeight(); yy++)
				map.getPosition(xcol, yy).setBlocked(true);
		}
		for (int yy = 0; yy < map.getFieldHeight() - size; yy++) {
			int yrow = yy % 2 == 0 ? yy / 2 : map.getFieldHeight() - yy / 2 - 1;
			for (int xx = 0; xx < map.getFieldWidth(); xx++)
				map.getPosition(xx, yrow).setBlocked(true);
		}
		
		map.sendUpdateToPlayers();
	}
	@Event
	public void onStartGame(GameInitEvent event) {
		int mcount = (int) (size * size * 0.2);
		if (mcount % 2 == 0)
			mcount++;
		event.getMap().setMinesCount(mcount);
		
		for (MinesweeperPlayingPlayer player : event.getMap().getPlayingPlayers()) {
			player.giveWeapon(new ClickWeapon());
			player.giveWeapon(new SizedBombWeapon(size / 3, size));
		}
	}
	
}
