package net.zomis.plugin.nonstandard;

import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.classic.DefaultExpanderRule;
import net.zomis.minesweeper.classic.EndShowMines;
import net.zomis.minesweeper.classic.StandardWeapons;
import net.zomis.minesweeper.events.Event;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.game.GamePreGenerateEvent;
import net.zomis.minesweeper.game.MinesweeperField;

public class ChessNeighbors extends MinesweeperPlugin implements EventListener {
	@Event
	public void onChessNeighbors(GamePreGenerateEvent event) {
		for (MinesweeperField mf : event.getMap().getIteration()) {
			mf.addNeighbor(-2, -1);
			mf.addNeighbor(-2, +1);
			mf.addNeighbor(-1, -2);
			mf.addNeighbor(-1, +2);
			mf.addNeighbor(+1, -2);
			mf.addNeighbor(+1, +2);
			mf.addNeighbor(+2, -1);
			mf.addNeighbor(+2, +1);
		}
	}
	
	@Override
	public void onDisable() {
	}

	@Override
	public void onEnable() {
		this.registerListener(new DefaultExpanderRule());
		this.registerListener(new EndShowMines());
		this.registerListener(this);
		this.registerListener(new StandardWeapons());
	}

	@Override
	public boolean canBeChosenBy(MinesweeperPlayer player) {
		return true;
	}
}
