package net.zomis.plugin.mtmt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.api.Minesweeper;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperServer;
import net.zomis.minesweeper.api.ServerSelectResult;
import net.zomis.minesweeper.events.invites.InviteGameStartingEvent;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class MataMata {
	private static final boolean useDB = false; // whether or not to add entries to the matamata table in the database. Does not affect the individual games.
	private Integer id = null;
	
	private final List<MinesweeperPlayer> players = new ArrayList<MinesweeperPlayer>();
	private List<Jogo> jogos = new ArrayList<Jogo>();
	private final MinesweeperPlayer creator;

	private boolean started = false;

	private boolean ended;

	private boolean	matchForThirdPrize = false;

	public Integer getId() {
		return this.id;
	}
	public boolean hasId() {
		return this.id != null;
	}
	public MataMata(MinesweeperPlayer creator) {
		if (creator == null) throw new IllegalArgumentException("Creator is null");
		
		this.creator = creator;
		this.players.add(creator);
		
		creator.getServer().getGameTagParameters("mata-mata", new MataMataIdSet(this));
	}
	
	private static class MataMataIdSet implements ServerSelectResult<Integer> {
		private MataMata mtmt;
		public MataMataIdSet(MataMata mtmt) {
			this.mtmt = mtmt; 
		}
		@Override
		public void onResult(List<Integer> result) {
			Integer last = null;
			if (!result.isEmpty()) last = result.get(result.size() - 1);
			if (last == null) last = 0;
			this.mtmt.id = last + 1;
			this.mtmt.getServer().broadcastLobbyChat(this.mtmt + " got id " + this.mtmt.id);
			this.mtmt = null;
		}
		@Override
		public void onError(Exception e) {
			this.mtmt.getServer().broadcastLobbyChat("Could not set id for " + mtmt + ": " + e.getMessage());
		}
	}
	
	public synchronized void cancel() {
		this.getServer().broadcastChat(this + " has been stopped by the creator!");
		this.endTournament();
	}
	public synchronized boolean playerJoin(MinesweeperPlayer user) {
		if (this.players.contains(user)) return false;
		this.players.add(user);
		return true;
	}
	public synchronized void start() {
		this.started = true;
		int n = this.players.size();
		
		Collections.shuffle(players);
	
		if (useDB)
		for (MinesweeperPlayer value : this.players) {
//			sendsql("UPDATE league SET division = $key WHERE (player = '" . $value->getName() . "') AND (leaguetype = 'mtmt')
//					AND (leagueid = " . $this->id . ")", true);
		}
		
//		for (MinesweeperPlayer value : this.players) {
//			 $players[$key] = $value->getName();// store usernames instead of mfeUser objects
//		}
		
		//	echo "Creating tournament with $n players\n";
		int f = (int) Math.ceil(Math.log(n) / Math.log(2)); // Possible problem here with the calculation. http://stackoverflow.com/questions/3305059/how-do-you-calculate-log-base-2-in-java-for-integers
		
		int oddgames = (int) (n - Math.pow(2, f - 1));
		//	echo "f: $f, oddgames=$oddgames\n";

		for (int i = 0; i < oddgames; i++) {
			MinesweeperPlayer player1 = players.remove(players.size() - 1);
			MinesweeperPlayer player2 = players.remove(0);
			jogos.add(new Jogo(this, player1, player2));
		}
	
		int pow2f = (int) Math.pow(2, f);
		int pow2fm = (int) Math.pow(2, f - 1);
//		int middle = (pow2f - pow2fm) / 2;
		int total = (int) Math.pow(2, f-2);
		int m = Math.max(0, total + pow2fm - n);// seems to be correct, at least for players 8 - 16
		int k = Math.min(Math.abs(n - pow2f), Math.abs(n - pow2fm));// correct
		int p = total - m - k;
		//	echo "total: $total, m: $m, k: $k, p: $p\n";
		
		int cjogo = 0;
		for (int i = 0; i < m; i++) {
			// Create the m games
			//		m = games with 2 players that have not previously played
			jogos.add(new Jogo(this, players.remove(0), players.remove(0))); //  array_shift($players), array_shift($players));
		}
		for (int i = 0; i < k; i++) {
			// Create the k games
			//		k = games with 1 player vs 1 earlier winner
			jogos.add(new Jogo(this, players.remove(0), cjogo++)); // [] = array(array_shift($players), $cjogo++);
		}
	
		for (int i = 0; i < p; i++) {
			// Create the p games
			//		p = games with 2 earlier winners
			jogos.add(new Jogo(this, cjogo++, cjogo++)); // $jogos[] = array($cjogo++, $cjogo++);
		}
	
		for (int currf = f - 3; currf >= 0; currf--) {
			for (int i = 0; i < Math.pow(2, currf); i++) {
				jogos.add(new Jogo(this, cjogo++, cjogo++)); // [] = array($cjogo++, $cjogo++);
			}
		}
		this.getServer().log("Players left in array: " + UtilZomisUtils.implode(",", players));
	
		if (this.matchForThirdPrize ) {
			jogos.add(new Jogo(this, -(jogos.size()-3), -(jogos.size()-2)));// this creates the match for 3rd prize
			// Switch last and 2nd last entry (final and 3rd-prize match)
			Collections.swap(jogos, jogos.size() - 1, jogos.size() - 2);
		}
		
		if (this.jogos.isEmpty()) throw new IllegalStateException("MataMata Jogos is empty: " + this);
		
		this.jogos = Collections.unmodifiableList(jogos);
		
		this.broadcastInfo();
		
		this.autoAIcheck();
		
		this.alertPlayers();
	}

	private synchronized void alertPlayers() {
		for (Jogo jogo : this.jogos) {
			jogo.alertPlayers();
		}
	}

	private synchronized void broadcastInfo() {
		for (MinesweeperPlayer player : this.getServer().getOnlinePlayers())
			this.sendInfo(player);
	}

	public MinesweeperServer getServer() {
		return Minesweeper.getServer();
	}

	public synchronized boolean isOpenForInvites() {
		return !this.started;
	}

	public synchronized MinesweeperPlayer getCreator() {
		return this.creator;
	}
	
	public synchronized void informGameEnd(MinesweeperGame game) {
//		this.getServer().broadcastChat("Mtmt informGameEnd: " + game);
		if (this.isEnded()) return;
		
		boolean isMtmt = false;
		for (Jogo jogo : this.jogos) {
			if (jogo.informGameEnd(game)) isMtmt = true;
		}
		if (!isMtmt) return;
		
//		this.getServer().broadcastChat("Mtmt Game Ended: " + game);
//		this.broadcastInfo();
		
		if (this.getUnfinishedGames().isEmpty()) {
			this.endTournament();
		}
		
		this.autoAIcheck();
	}

	private synchronized void endTournament() {
		this.ended = true;
		this.broadcastInfo();
		if (this.jogos != null && !this.jogos.isEmpty()) {
			if (this.jogos.get(this.jogos.size() - 1).getGame() != null)
			for (MinesweeperPlayingPlayer player : this.jogos.get(this.jogos.size() - 1).getGame().getPlayingPlayers()) {
				if (player.isEliminated()) continue;
				
				this.getServer().getServerPlayer().performCommand("/donut " + player.getPlayer().getDisplayName() + " for winning " + this);
			}
		}
	}

	private synchronized List<Jogo> getUnfinishedGames() {
		List<Jogo> result = new ArrayList<Jogo>();
		for (Jogo jogo : this.jogos) {
			if (!jogo.isFinished()) {
				result.add(jogo);
			}
		}
		return result;
	}

	public synchronized void sendInfo(MinesweeperPlayer player) {
		player.sendChatBy("Mata-Mata. Jogos = " + this.jogos.size() + " creator = " + this.getCreator(), player.getServer().getServerPlayer(), 0xffff00);
		if (this.isOpenForInvites()) {
			for (MinesweeperPlayer p : this.players) player.sendChat("Player is signed up: " + p.getDisplayName());
		}
		else {
			int dec3rd = this.matchForThirdPrize ? 0 : 1;
			for (int key = 0; key < this.jogos.size(); key++) {
				int cnt = this.jogos.size();

				if (key == cnt - 64 + dec3rd) player.sendChatBy("64th-finals:", player.getServer().getServerPlayer());
				else if (key == cnt-32 + dec3rd) player.sendChatBy("32nd-finals:", player.getServer().getServerPlayer());
				else if (key == cnt-16 + dec3rd) player.sendChatBy("16th-finals:", player.getServer().getServerPlayer());
				else if (key == cnt-8 + dec3rd) player.sendChatBy("Quarterfinals:", player.getServer().getServerPlayer());
				else if (key == cnt-4 + dec3rd) player.sendChatBy("Semifinals:", player.getServer().getServerPlayer());
				else if (key == cnt-2 + dec3rd && this.matchForThirdPrize) player.sendChatBy("Match for 3rd prize:", player.getServer().getServerPlayer());
				else if (key == cnt-1) player.sendChatBy("Final:", player.getServer().getServerPlayer());

				Jogo jogo = this.jogos.get(key);
				jogo.sendInfo(player);
			}
		}
	}

	public synchronized int getJogoIndex(Jogo jogo) {
		return this.jogos.indexOf(jogo);
	}
	
	private synchronized void autoAIcheck() {
		for (Jogo jogo : this.jogos) jogo.autoAIcheck();
	}

	public String[] getPlugins() {
		return null; // Classic plugins = null
	}

	public synchronized void informGameStart(InviteGameStartingEvent event) {
		for (Jogo jogo : this.jogos) {
			jogo.matches(event);
		}
	}

	public synchronized void informJogoEnd(Jogo jogo) {
		for (Jogo j : this.jogos) {
			j.informJogoEnd(jogo, this.getJogoIndex(jogo));
		}
	}

	public synchronized Jogo getJogo(int jogoIndex) {
		return this.jogos.get(jogoIndex);
	}

	public synchronized boolean isEnded() {
		return ended;
	}

	public synchronized void walkover(MinesweeperPlayer player) {
		if (this.isOpenForInvites()) {
			this.players.remove(player);
		}
		else {
			for (Jogo jogo : this.jogos) {
				jogo.informWalkover(player);
			}
		}
		
	}

	@Override
	public String toString() {
		return this.id == null ? super.toString() : "MataMata #" + this.id;
	}
	
}
