package net.zomis.plugin.floodfill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.weapons.BaseWeapon;

public class FloodFillWeapon extends BaseWeapon {
	
	private static final int numberOfUses = 3;
	private int hasUsed = 0;

	@Override
	public String getWeaponType() {
		return "P"; // TODO: Auto-Assign WeaponTypes, and make it easier to choose weapons. P is used in FloodFillWeapon only because it's the default weapon in the clients.
	}

	@Override
	public boolean canUseAt(MinesweeperPlayingPlayer user, MinesweeperField field) {
		return !field.isClicked();
	}

	@Override
	public Collection<MinesweeperField> getFieldsAffected(MinesweeperPlayingPlayer user, MinesweeperField field) {
		Collection<MinesweeperField> result = new ArrayList<MinesweeperField>();
		result.add(field);
		recursiveAdd(result, field, new RecursiveInterface() {
			@Override
			public boolean performAdd(MinesweeperField from, MinesweeperField to) {
				return this.performRecursive(from, to);
			}
			@Override
			public Collection<MinesweeperField> getRecursiveFields(MinesweeperField field) {
				Set<MinesweeperField> fields = new HashSet<MinesweeperField>();
				fields.add(field.getRelativePosition(-1, 0));
				fields.add(field.getRelativePosition(0, -1));
				fields.add(field.getRelativePosition(1, 0));
				fields.add(field.getRelativePosition(0, 1));
				return fields;// .getNeighbors();
			}
			@Override
			public boolean performRecursive(MinesweeperField from, MinesweeperField to) {
				if (from.isMine()) {
					return to.getMineValue() == from.getMineValue();
				}
				else {
					return !to.isMine() && to.getValue() == from.getValue();
				}
			}
		});
		
		return result;
	}

	@Override
	public boolean useAt(MinesweeperMove moveInfo) {
		if (!this.canUseAt(moveInfo.getPlayer(), moveInfo.getMovePosition())) return false;
		
//		ZomisUtils.echo("useAt can use ok.");
		
//		MinesweeperMove move = new MinesweeperMove(user, this, field);
//		for (MinesweeperField mf : this.getFieldsAffected(user, move.getMovePosition())) {
		for (MinesweeperField mf : this.getFieldsAffected(moveInfo.getPlayer(), moveInfo.getMovePosition())) {
			mf.activate(moveInfo);
		}
		
		moveInfo.getMap().nextTurn();
		return true;
	}

	@Override
	public boolean canUse(MinesweeperPlayingPlayer user) {
		return this.hasUsed < FloodFillWeapon.numberOfUses;
	}

	@Override
	public void resetUsage() {
		this.hasUsed = 0;
	}

}
