package net.zomis.plugin.floodfill;

import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.classic.DefaultExpanderRule;
import net.zomis.minesweeper.classic.EndShowMines;
import net.zomis.minesweeper.classic.StandardNeighbors;
import net.zomis.minesweeper.events.Event;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.game.GameInitEvent;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class FloodFillPlugin extends MinesweeperPlugin implements EventListener {
	@Event
	public void onGameInit(GameInitEvent event) {
		for (MinesweeperPlayingPlayer player : event.getMap().getPlayingPlayers()) {
			player.giveWeapon(new FloodFillWeapon());
		}
	}
	
	@Override
	public void onDisable() {
	}

	@Override
	public void onEnable() {
		this.registerListener(new DefaultExpanderRule());
		this.registerListener(new EndShowMines());
		this.registerListener(new StandardNeighbors());
		this.registerListener(this);
	}

	@Override
	public boolean canBeChosenBy(MinesweeperPlayer arg0) {
		return true;
	}
}
