package net.zomis.plugin.editor;

import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.classic.StandardNeighbors;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.Event;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.game.GameInitEvent;
import net.zomis.minesweeper.events.invites.InvitePreStartEvent;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class Editor extends MinesweeperPlugin implements EventListener {
	@Event
	public void onInviteGameStart(InvitePreStartEvent event) {
		if (event.getInvite().getPlugins().contains(this)) {
			event.getInvite().setDatabase(false);
//			event.getInvite().getHost().sendAlert("Editor detected. No database.");
		}
	}
	
	@Command(command = "editor", help = "")
	public void command(PlayerCommandEvent event) {
		if (event.getPlayer().getGame() == null) return;
		if (!event.getPlayer().getGame().hasPlugin(this)) return;
		
//		MinesweeperPlayingPlayer pp = event.getPlayer().getGame().getPlayingPlayer(event.getPlayer());
//		EditorWeapon wp = (EditorWeapon) pp.getWeapons().get(0);
//		wp.setMode(Integer.parseInt(event.getParameter(0)));
	}
	
	@Event
	public void onGameStart(GameInitEvent event) {
		event.getGame().sendChatMessage("This is an editor. Any player can modify the map at any time.");
		event.getGame().setActionMode(true);
		for (MinesweeperPlayingPlayer player : event.getMap().getPlayingPlayers()) {
			player.giveWeapon(new EditorWeapon(player));
		}
	}
	
	@Override
	public void onDisable() {
	}

	@Override
	public void onEnable() {
		this.registerListener(this);
		this.registerListener(new StandardNeighbors());
	}

	@Override
	public boolean canBeChosenBy(MinesweeperPlayer user) {
		return user.hasPermission(PlayerCommandEvent.PERMISSION_TESTER);
	}
}
