package net.zomis.plugin.classic;

import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.classic.DefaultExpanderRule;
import net.zomis.minesweeper.classic.EndShowMines;
import net.zomis.minesweeper.classic.StandardNeighbors;
import net.zomis.minesweeper.classic.StandardWeapons;
import net.zomis.minesweeper.events.Event;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.invites.InvitePreStartEvent;

// WHEN CHANGING NAME OF THIS PLUGIN, ALSO CHANGE "GETDEFAULTPLUGINS" IN MFESERVER.JAVA
public class PluginClassicGame extends MinesweeperPlugin implements EventListener {
	@Override
	public void onDisable() {
	}

	@Override
	public void onEnable() {
		this.registerListener(new DefaultExpanderRule());
		this.registerListener(new EndShowMines());
		this.registerListener(new StandardNeighbors());
		this.registerListener(new StandardWeapons());
		this.registerListener(this);
	}

	@Event
	public void onInvite(InvitePreStartEvent event) {
		for (MinesweeperPlugin plugin : event.getInvite().getPlugins())
		if (plugin != null && plugin.getSimpleName().contentEquals(this.getSimpleName()))
			return;
		
		event.getInvite().setRating(false);
	}
	
	@Override
	public boolean canBeChosenBy(MinesweeperPlayer arg0) {
		return true;
	}
}
