package net.zomis.listeners.invites;

import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.Event;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.invites.InviteOpenEvent;
import net.zomis.minesweeper.events.invites.InvitePreStartEvent;

public class WithOrWithoutDatabase extends MinesweeperPlugin implements EventListener {
	@Event
	public void onPluginsCheck(InviteOpenEvent event) {
//		String[] okPlugins = new String[]{ PluginClassicGame.class.getSimpleName(), TwoVsTwo.class.getSimpleName(), NoBomb.class.getSimpleName(), FloodFillPlugin.class.getSimpleName(),
//				DoubleLineNeighbors.class.getSimpleName(), ChessNeighbors.class.getSimpleName() };
//		
//		for (MinesweeperPlugin pl : event.getInvite().getPlugins()) {
//			boolean isOK = false;
//			for (String str : okPlugins)
//			if (pl.getSimpleName().equalsIgnoreCase(str)) isOK = true;
//			
//			if (!isOK) {
//				event.getInvite().setDatabase(false);
//				event.getInvite().getHost().sendAlert("This game is set to be played without database");
//			}
//		}
		MinesweeperPlayer host = event.getInvite().getHost();
		if (host.getFacebookUsername().contentEquals("andre.samuelsson.42") && host.isClientAndroid()) {
			host.sendChat("Hello Tejpbit. Inget databasaktiverat spel fr dig inte, sg till nr det ska vara aktiverat igen. Klassen heter WithOrWithoutDatabase. Ctrl+Shift+T.");
			host.sendAlert("Hello Tejpbit. Inget databasaktiverat spel fr dig inte, sg till nr det ska vara aktiverat igen. Klassen heter WithOrWithoutDatabase. Ctrl+Shift+T.");
			event.getInvite().setDatabase(false);
		}
	}

	@Event
	public void onlyAIsCheck(InvitePreStartEvent event) {
		if (event.getInvite().isDatabase() != null) return;
		
		boolean hasNonAI = false;
		for (MinesweeperPlayer player : event.getInvite().getPlayers()) {
			if (!player.isAI()) hasNonAI = true;
			
			// Never allow database for games where the following AIs participate.
			if (player.getName().equalsIgnoreCase("#AI_Impossible")) event.getInvite().setDatabase(false);
			if (player.getName().equalsIgnoreCase("#AI_OpenField")) event.getInvite().setDatabase(false);
			if (player.getName().equalsIgnoreCase("#AI_TestZ")) event.getInvite().setDatabase(false);
			
//			if (player.getName().equalsIgnoreCase("#AI_Nightmare")) event.getInvite().setDatabase(false);
		}
		if (!hasNonAI) event.getInvite().setDatabase(false); // only AIs playing
	}
	
	@Override
	public boolean canBeChosenBy(MinesweeperPlayer arg0) {
		return false;
	}

	@Override
	public void onDisable() {
	}

	@Override
	public void onEnable() {
		this.registerListener(this);
	}
}
