package net.zomis.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class GameResults1v1 {

	public class PlayerResults {
		private PlayerResults() {}
		
		private Map<String, Integer> wins = new HashMap<String, Integer>();
		private Map<String, Integer> totalGames = new HashMap<String, Integer>();
		
		public void addResult(MinesweeperPlayingPlayer opponent) {
			mapChange(wins, opponent, opponent.getResultPosition() == 1 ? 0 : 1);
			mapChange(totalGames, opponent, 1);
		}
		public int getWins(String key) {
			return wins.get(key) == null ? 0 : wins.get(key);
		}
		public int getTotal(String key) {
			return totalGames.get(key) == null ? 0 : totalGames.get(key);
		}
		public double getPercent(String key) {
			return (double) getWins(key) / (double) getTotal(key);
		}
		public Set<String> getKeys() {
			return this.wins.keySet();
		}
		private void mapChange(Map<String, Integer> map, MinesweeperPlayingPlayer opponent, int change) {
			Integer oldValue = map.get(key(opponent));
			if (oldValue == null) oldValue = 0;
			
			map.put(key(opponent), oldValue + change);
		}
	}
	private Map<String, PlayerResults> scores = new HashMap<String, PlayerResults>();
	private final boolean separateIndex;
	
	public GameResults1v1(boolean separateIndex) {
		this.separateIndex = separateIndex;
	}

	public Map<String, PlayerResults> getResults() {
		return new HashMap<String, GameResults1v1.PlayerResults>(this.scores);
	}

	public void saveResult(List<MinesweeperPlayingPlayer> pplayers) {
		if (pplayers.size() != 2) throw new UnsupportedOperationException("Method only works for 2 players");
		for (MinesweeperPlayingPlayer pp1 : pplayers) {
			if (!scores.containsKey(key(pp1))) scores.put(key(pp1), new PlayerResults());
			PlayerResults result = scores.get(key(pp1));
			
			for (MinesweeperPlayingPlayer pp2 : pplayers) {
				if (pp1 == pp2) continue;
				
				result.addResult(pp2);
			}
		}
	}
	
	private String key(MinesweeperPlayingPlayer pp) {
		return this.separateIndex ? pp.getName() + "@" + pp.getIndex() : pp.getName();
	}
}