package net.zomis.minesweeper.player;

import net.zomis.minesweeper.api.FieldInfo;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.Metadata;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperServer;
import net.zomis.minesweeper.api.UserClient;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class SimplePlayer implements MinesweeperPlayer {
	private String	name;
	private Double	rating;
	private PlayerHelper frame;
	private Metadata metadata;
	private int	budget;

	public SimplePlayer(PlayerHelper helper) {
		this.frame = helper;
	}

	@Override
	public String getDisplayName() {
		return this.getName();
	}

	@Override
	public String getName() {
		return this.name;
	}
	@Override
	public MinesweeperGame getGame() {
		return null;
	}

	@Override
	public MinesweeperGame getPlayingGame() {
		return null;
	}

	@Override
	public Integer getGameID() {
		return -42;
	}

	@Override
	public MinesweeperGame getObservingGame() {
		return null;
	}

	@Override
	public Double getRating() {
		return this.rating;
	}

	@Override
	public boolean hasAccessToCommand(String command) {
		return true;
	}

	@Override
	@Deprecated
	public boolean hasPermission(int permission) {
		return true;
	}

	@Override
	public boolean isAI() {
		return false;
	}

	@Override
	public boolean isGuest() {
		return false;
	}

	@Override
	public boolean isInGame() {
		return true;
	}

	@Override
	public boolean isObserving() {
		return false;
	}

	@Override
	public boolean isOnline() {
		return true;
	}

	@Override
	public boolean isRealPlayer() {
		return true;
	}

	@Override
	public boolean isServer() {
		return false;
	}

	@Override
	public boolean isTemporaryPlayer() {
		return false;
	}

	@Override
	public boolean sendChat(String message) {
		this.frame.sendText(message + "\n");
		return true;
	}

	@Override
	public void sendChatBy(String message, MinesweeperPlayer from) {
		this.sendChatBy(message, from, from == null ? null : from.getChatColor());
	}

	@Override
	public void sendChatBy(String message, MinesweeperPlayer from, Integer chatColor) {
		this.sendChat((from == null ? "" : from.getName() + ": ") + message);
	}

	@Override
	public boolean sendChat(String message, Integer chatColor) {
		return false;
	}

	@Override
	public void sendFieldImage(MinesweeperField field, String url) {
		throw new UnsupportedOperationException();
	}

	@Override
	public MinesweeperServer getServer() {
		return null;
	}

	@Override
	public Metadata getMetadata() {
		return this.metadata;
	}

	@Override
	public void sendFieldInfo(MinesweeperField field, MinesweeperPlayingPlayer player, boolean highlight) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void sendAlert(String alertMessage) {
		this.frame.alert(alertMessage);
	}

	@Override
	public boolean isClientAndroid() {
		return false;
	}

	@Override
	public boolean isClientFlash() {
		return false;
	}

	@Override
	public boolean hasMineCoins(int amount) {
		return this.budget >= amount;
	}

	@Override
	public int getMineCoins() {
		return this.budget;
	}

	@Override
	public boolean addMineCoins(int amount) {
		if (amount < 0 && !this.hasMineCoins(amount)) return false;
		this.budget += amount;
		return true;
	}

	@Override
	public Integer getChatColor() {
		return null;
	}

	@Override
	public void sendFieldInfo(MinesweeperField fieldPosition, MinesweeperPlayingPlayer player, int fieldType, boolean isMine, int value, boolean highlight) {
		throw new UnsupportedOperationException();
	}

	@Override
	public Invite createInvitation(String[] plugins) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void performCommand(String command) {
		throw new UnsupportedOperationException();
	}

	@Override
	public boolean hasPermission(String requiredPermission) {
		return true;
	}

	@Override
	public String getFacebookUsername() {
		return null;
	}

	@Override
	public int getUserId() {
		return -41;
	}

	@Override
	public UserClient getClient() {
		return UserClient.JAVA;
	}

	@Override
	public MinesweeperMap getMap() {
		return this.frame.getMap();
	}
	
	@Override
	public void refreshMapView() {
		if (this.getMap() != null) this.getMap().sendUpdateToPlayers();
	}
	
	@Override
	public String toString() {
		return this.getName();
	}

	@Override
	public void sendFieldInfo(MinesweeperField fieldPosition, FieldInfo fieldInfo) {
		throw new UnsupportedOperationException();
	}
	
	public void setName(String name) {
		this.name = name;
	}
}
