package net.zomis.minesweeper.game.model;

import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.BaseEvent;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.functional.Consumer;

public class EventHandler<E extends BaseEvent> {
	private final MinesweeperPlugin plugin;
	private final Consumer<E> handler;

	private final EventListener object;
	public EventListener getListener() {
		return object;
	}

	public EventHandler(MinesweeperPlugin plugin, EventListener listener, Consumer<E> handler) {
		this.plugin = plugin;
		this.object = listener;
        this.handler = handler;
	}

	public void execute(E event) {
		try {
            handler.accept(event);
		} catch (RuntimeException e1) {
			if (event instanceof PlayerCommandEvent) {
				((PlayerCommandEvent) event).getPlayer().sendAlert("Error handling command: " + e1.getCause().toString() + "\n" + UtilZomisUtils.implodeArr("\n", e1.getStackTrace()));
			}

            // logger.error("Exception when performing EventHandler " + this.getPlugin().getSimpleName() + " for event " + event.toString(), e1);
            throw e1;
		}
	}

	@Override
	public String toString() {
		return "(" + plugin + ": " + handler + ")";
	}

    @Deprecated
	public MinesweeperPlugin getPlugin() {
		return plugin;
	}
}
