package net.zomis.minesweeper.game.model;

import net.zomis.minesweeper.api.ai.AISupplier;
import net.zomis.minesweeper.api.ai.MinesweeperAI;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class MfeAI extends MfePlayer implements MinesweeperPlayingPlayer {
	public static final int DEFAULT_DELAY = 300;
	
	private final MinesweeperAI ai;

	public MfeAI(MinesweeperMap map, MinesweeperPlayer player,
             AISupplier constructor, int index) {
		super(map, player, index);
		this.ai = constructor.get(this);
	}

	@Override
	public String getName() {
		return this.ai.getName();
	}
	
	@Override
	public MinesweeperAI getAI() {
		return this.ai;
	}
	
	@Override
	public boolean isAI() {
		return true;
	}
	
	@Override
	public void eliminate(final int resultPosition) {
		super.eliminate(resultPosition);
		
		final MfeMap map = (MfeMap) this.getMap();
        map.removePlayer(this);
	}
}
