package net.zomis.minesweeper.game.model;

import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.game.MoveAllowedState;

public class SpecialMove extends MfeMove {

	private final String data;

	public SpecialMove(MinesweeperPlayingPlayer player, String data) {
		super(player, UtilZomisUtils.substr(data, 0, 2), null);
		this.data = data;
	}
	
	public MoveAllowedState performSpecialMove() {
		if (this.getPlayer().isEliminated()) return MoveAllowedState.MOVE_FAILED;
		
		if (this.getWeaponType().contentEquals("#W"))
			((MfePlayer) this.getPlayer()).walkover();
		
		if (this.getWeaponType().contentEquals("#S"))
			((MfePlayer) this.getPlayer()).surrender();
		
		if (this.getWeaponType().contentEquals("#D"))
			((MfePlayer) this.getPlayer()).proposeDraw();
		
		return MoveAllowedState.OK;
	}
	
	@Override
	public MoveAllowedState getMoveAllowedState() {
		return this.getPlayer().isEliminated() ? MoveAllowedState.MOVE_FAILED : MoveAllowedState.OK;
	}
	@Override
	public String toString() {
		return this.data;
	}

	public String getType() {
		return UtilZomisUtils.substr(data, 1, 1);
	}
	public int getPlayerIndex() {
		try {
			return Integer.parseInt(UtilZomisUtils.substr(this.data, -1)) - 1;
		}
		catch (NumberFormatException e) {
			return -1;
		}
	}
	
	@Override
	public String getMoveString() {
		return this.data;
	}
}
