package net.zomis.minesweeper.game.model;

import java.util.*;

import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.BaseEvent;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.game.GameEvent;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.functional.Consumer;

public class MinesweeperEvents {
	private final Map<Class<? extends BaseEvent>, Collection<EventHandler<?>>> bindings;
	private final Map<String, EventHandler<PlayerCommandEvent>> commands;

    @Deprecated
	private static final MinesweeperEvents eventHandler = new MinesweeperEvents();

    @Deprecated
	public static Set<String> getRegistredCommands() {
		return new HashSet<String>(getCreate().commands.keySet());
	}
    @Deprecated
	public static EventHandler getCommand(String command) {
		return eventHandler.commands.get(command);
	}

/*

    @Deprecated
	public MinesweeperEvents activatePlugin(MinesweeperPlugin plugin, PluginHelper helper) {
		if (plugin.isEnabled()) 
			throw new IllegalArgumentException("Plugin " + plugin + " is already enabled");

        plugin.initialize(Minesweeper.getServer(), helper, file);
		plugin.setEnabled(true);
        // MinesweeperEvents.executeEvent(new PluginEnableEvent(plugin));
		return this;
	}*/
	
	public MinesweeperEvents() {
		this.bindings = new HashMap<Class<? extends BaseEvent>, Collection<EventHandler<?>>>();
		this.commands = new HashMap<String, EventHandler<PlayerCommandEvent>>();
	}
	
    @Deprecated
	public static boolean canHandleCommand(String command, MinesweeperPlayer user) {
		return eventHandler.commands.containsKey(command);
		// Whether or not user has access to the command, is handled in MfeUser.hasAccessToCommand
	}
	
	/**
	 * Alerts all listeners about an event.
	 * 
	 * @param event The event
	 * @return The same event
	 */
	public <T extends BaseEvent> T executeEvent(T event) {
		Collection<EventHandler<?>> handlers;
		
		if (!(event instanceof PlayerCommandEvent)) {
            handlers = bindings.get(event.getClass());
			if (handlers == null) {
                return event;
            }
		}
		else {
			String command = ((PlayerCommandEvent)event).getCommand();
			EventHandler<PlayerCommandEvent> eh = commands.get(command);
			if (eh == null) {
				return event;
			}
            eh.execute((PlayerCommandEvent)event);
			return event;
		}
		
		for (EventHandler<?> handler : handlers) {
			if (handler == null) {
                throw new NullPointerException("A null handler was added to handlers for event " + event);
            }
			
			if (event instanceof GameEvent) { // Check if game has plugin activated before actually calling the handler
				GameEvent g = (GameEvent) event;

				if (!g.getMap().hasPlugin(handler.getPlugin())) {
					continue;
				}
			}
			
			try {
                ((EventHandler<T>)handler).execute(event);
			} catch (Exception e) {
                throw new RuntimeException(e);
				// logger.error(String.format("Error handling event %s in %s: %s", event.toString(), handler.toString(), e.getMessage()), e);
			}
		}
		return event;
	}

    @Deprecated
	public static MinesweeperEvents getCreate() {
		return MinesweeperEvents.eventHandler;
	}

    public <T extends BaseEvent> void registerListener(final MinesweeperPlugin plugin, final EventListener listener,
                                                       final Class<T> clazz, final Consumer<T> handler) {
        if (!this.bindings.containsKey(clazz)) {
            this.bindings.put(clazz, new ArrayList<EventHandler<?>>());
        }
        this.bindings.get(clazz).add(new EventHandler<T>(plugin, listener, handler));
    }

    public void registerCommand(final MinesweeperPlugin plugin, final String command,
              final EventListener listener, final Consumer<PlayerCommandEvent> handler) {
        if (this.commands.containsKey(command)) {
            throw new IllegalStateException("Command " + command +
                    " was registred by " + this.commands.get(command).getPlugin().getSimpleName()
                    + ", cannot register " + handler + " in " + plugin.getSimpleName());
        }
        EventHandler<PlayerCommandEvent> eh = new EventHandler<PlayerCommandEvent>(plugin, listener, handler);
        this.commands.put(command, eh);
    }

	/**
	 * Removes a listener from bindings
	 * @param listener The {@link EventListener} to remove
	 */
	public static void removeListenerFromBindings(EventListener listener) {
		for (Map.Entry<Class<? extends BaseEvent>, Collection<EventHandler<?>>> ee : eventHandler.bindings.entrySet()) {
			Iterator<EventHandler<?>> it = ee.getValue().iterator();
			while (it.hasNext()) {
				EventHandler<?> eh = it.next();
				if (eh.getListener() == listener) {
					it.remove();
				}
			}
		}
	}

    @Deprecated
	public static void clearListeners() {
		eventHandler.bindings.clear();
		eventHandler.commands.clear();
	}
}
