package net.zomis.minesweeper.game.model;

import java.util.ArrayList;
import java.util.List;

import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.game.MinesweeperReplay;

public class GameReplay implements MinesweeperReplay {
//	private static final Logger logger = Logger.getLogger(GameReplay.class); // "Replay" tag.
	public static int CHARS_PER_POS = 2;
	public static int CHARS_PER_CLICK = CHARS_PER_POS + 1;
	
	private final MinesweeperGame game;
	private final MinesweeperMap map;
	private final String clicksString;
	private final String minepos;
	private final List<MinesweeperMove> moves;
//	private final Map<MinesweeperPlayingPlayer, MinesweeperWeapon>
	
	public GameReplay(String minepos, String clicksString, MinesweeperMap map) {
		if (map instanceof MinesweeperGame) this.game = (MinesweeperGame) map;
		else this.game = null;
		this.map = map;
		this.map.setMinePositions(minepos);
		
		this.minepos = minepos;
		this.clicksString = clicksString;
		
		this.moves = new ArrayList<MinesweeperMove>(this.getMoveCount());
		// To create the list of all the moves made in the game, we have to loop through the replay here. There's no way to know who made which move otherwise.
		while (this.hasMoreMoves()) {
			this.moves.add(this.getMoveAt(position));
			this.nextMove();
		}
		this.setPosition(0);
	}
	
	private MinesweeperMove getMoveAt(int position) {
		String click = UtilZomisUtils.substr(clicksString, position * CHARS_PER_CLICK, CHARS_PER_CLICK);
		if (click.length() < CHARS_PER_CLICK) return null;
		
//		return MinesweeperMove.createFromString(this.getMap(), click);
		return this.getMap().getCurrentPlayer().createMove(click);
	}
	
	private int position = 0;
	
	@Override
	public boolean hasMoreMoves() {
		return this.position < this.getMoveCount();
	}
	
	@Override
	public int getMoveCount() {
		return this.clicksString.length() / CHARS_PER_CLICK;
	}
	
	@Override
	public boolean nextMove() {
//		logger.info("Clicks: " + this.clicksString);
		String click = UtilZomisUtils.substr(clicksString, this.getPosition() * CHARS_PER_CLICK, CHARS_PER_CLICK);
		if (click.length() < CHARS_PER_CLICK) return false;
		this.position++;
		((MfeMap) this.map).performClicks(click);
		return true;
	}
	@Override
	public void previousMove() {
		this.setPosition(this.getPosition() - 1);
	}
	@Override
	public void rewind() {
		this.position = 0;
		// Do not call setPosition, as that calls this method.
		// Reload map from String data, re-init all plugins, do not generate any new mineposition.
		this.map.setMinePositions(this.minepos, GameReplay.CHARS_PER_POS); // this takes care of clearing, resetting minepos, and notifying plugins
		
		// Reset players and their weapons so that we can use them again.
		for (MinesweeperPlayingPlayer pp : this.map.getPlayingPlayers()) {
			pp.reset();
		}
		
		this.map.setCurrentPlayerTurn(0);
		
		if (this.game != null) this.game.sendUpdateToPlayers();
	}
	@Override
	public MinesweeperGame getGame() {
		return game;
	}
	@Override
	public int getPosition() {
		return position;
	}
	@Override
	public void setPosition(int position) {
		if (position < 0) throw new IllegalArgumentException("Position cannot be negative.");
		
		if (position < this.getPosition()) {
			this.rewind(); // Start from beginning and then go forward
			for (int i = 0; i < position; i++) this.nextMove();
		}
		else if (position > this.getPosition()) {
			for (int i = this.getPosition(); i < position; i++) this.nextMove();
		}
//		MinesweeperEvents.executeEvent(new ReplayMoveEvent(this, position));
		this.position = position;
	}
	@Override
	public MinesweeperMap getMap() {
		return this.map;
	}

	@Override
	public List<MinesweeperMove> getMoves() {
		return new ArrayList<MinesweeperMove>(this.moves);
	}

//	@Override
//	public Iterator<MinesweeperMove> iterator() {
//		return this.getMoves().iterator();
//	}
}
