/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.game.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.zomis.UtilZomisList;
import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.api.MapFactory;
import net.zomis.minesweeper.api.MinesweeperAI;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.CancellableEvent;
import net.zomis.minesweeper.events.game.AIExceptionEvent;
import net.zomis.minesweeper.events.game.CustomEvent;
import net.zomis.minesweeper.events.game.GameEndedEvent;
import net.zomis.minesweeper.events.game.GamePostGenerateEvent;
import net.zomis.minesweeper.events.game.GamePreGenerateEvent;
import net.zomis.minesweeper.events.game.GameSendUpdateEvent;
import net.zomis.minesweeper.events.game.GameTurnChangeEvent;
import net.zomis.minesweeper.events.game.PlayerAfterMoveEvent;
import net.zomis.minesweeper.events.game.PlayerEliminateCheckEvent;
import net.zomis.minesweeper.events.game.PlayerMoveEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.game.MinesweeperReplay;
import net.zomis.minesweeper.game.MoveAllowedState;
import net.zomis.minesweeper.game.model.GameReplay;
import net.zomis.minesweeper.game.model.MapFactoryImpl;
import net.zomis.minesweeper.game.model.MapListIterator;
import net.zomis.minesweeper.game.model.MapUtils;
import net.zomis.minesweeper.game.model.MfeAI;
import net.zomis.minesweeper.game.model.MfeField;
import net.zomis.minesweeper.game.model.MfeMove;
import net.zomis.minesweeper.game.model.MfePlayer;
import net.zomis.minesweeper.game.model.MinesweeperEvents;
import net.zomis.minesweeper.game.model.SpecialMove;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public abstract class MfeMap
implements MinesweeperMap {
    private static final int POSITION_RADIX = 16;
    private int endGameWhenPlayersLeftCount = 1;
    private final Random random = new Random();
    protected final List<MinesweeperPlayingPlayer> playingPlayers = new ArrayList<MinesweeperPlayingPlayer>(2);
    private final List<MinesweeperPlugin> activePlugins;
    private int mapWidth;
    private int mapHeight;
    private List<List<MinesweeperField>> map;
    protected final List<MinesweeperMove> moveHistory = new LinkedList<MinesweeperMove>();
    private boolean actionMode = false;
    private int playerTurn = 0;
    private int clicks = 0;
    protected boolean serverControlled = false;
    protected boolean endGameCalled = false;
    private static Random staticRandom = new Random();
    protected boolean isReplay = false;
    private boolean isAIDelay = false;
    private int minesCount;
    private boolean gameIsEnding = false;

    public MfeMap() {
        this.activePlugins = new LinkedList<MinesweeperPlugin>();
    }

    public void addPlayer(MinesweeperPlayingPlayer playing) {
        this.playingPlayers.add(playing);
    }

    public List<MinesweeperMove> getMoveHistory() {
        return new ArrayList<MinesweeperMove>(this.moveHistory);
    }

    public boolean isServerControlled() {
        return this.serverControlled;
    }

    public int getClickCount() {
        return this.clicks;
    }

    private List<MinesweeperField> getAllPlaceableMineFields() {
        ArrayList<MinesweeperField> allFields = new ArrayList<MinesweeperField>();
        Iterator<MinesweeperField> iterator = this.iterator();
        while (iterator.hasNext()) {
            MinesweeperField mf = iterator.next();
            if (mf.isBlocked()) continue;
            allFields.add(mf);
        }
        return allFields;
    }

    public void generate(int mines) {
        this.generate(mines, staticRandom);
    }

    public CustomEvent executeCustomEvent(CustomEvent customEvent) {
        return MinesweeperEvents.executeEvent(customEvent);
    }

    public void generate(int mines, Random randomizer) {
        if (randomizer == null) {
            randomizer = this.random;
        }
        MinesweeperEvents.executeEvent(new GamePreGenerateEvent((MinesweeperMap)this));
        List<MinesweeperField> fields = this.getAllPlaceableMineFields();
        if (fields.size() < mines) {
            throw new IllegalStateException("Not enough room for all mines: " + fields.size() + " vs " + this.getMinesCount());
        }
        this.clearMap();
        this.setCurrentPlayerTurn(0);
        this.moveHistory.clear();
        for (int i = 0; i < mines; ++i) {
            MinesweeperField random = (MinesweeperField)UtilZomisList.getRandom(fields, (Random)randomizer);
            random.setMine(true);
            fields.remove(random);
        }
        this.postGenerate();
    }

    @Deprecated
    public void generate(Random randomizer) {
        this.generate(this.getMinesCount(), randomizer);
    }

    public void generate() {
        this.generate(staticRandom);
    }

    private void clearMap() {
        Iterator<MinesweeperField> iterator = this.iterator();
        while (iterator.hasNext()) {
            MinesweeperField mf = iterator.next();
            if (mf.isClicked()) {
                mf.inactivate();
            }
            mf.setMine(false);
        }
    }

    protected void postGenerate() {
        this.initFields();
        this.clicks = 0;
        MinesweeperEvents.executeEvent(new GamePostGenerateEvent((MinesweeperMap)this));
    }

    public void initFields() {
        Iterator<MinesweeperField> iterator = this.iterator();
        while (iterator.hasNext()) {
            MinesweeperField mf = iterator.next();
            mf.init();
        }
    }

    public boolean initMap(int mapWidth, int mapHeight) {
        this.minesCount = (int)((double)(mapWidth * mapHeight) * 0.2);
        this.mapWidth = mapWidth;
        this.mapHeight = mapHeight;
        this.map = new ArrayList<List<MinesweeperField>>(mapWidth);
        for (int xx = 0; xx < mapWidth; ++xx) {
            this.map.add(xx, new ArrayList(mapHeight));
        }
        for (int yy = 0; yy < mapHeight; ++yy) {
            for (int xx = 0; xx < mapWidth; ++xx) {
                MinesweeperField t = this.newTile(this, xx, yy);
                this.map.get(xx).add(yy, t);
            }
        }
        return true;
    }

    public void performScoreChange(MinesweeperPlayingPlayer player, int change) {
        player.changeScore(change);
    }

    protected void postMove(MinesweeperMove move) {
        if (move != null) {
            ++this.clicks;
            this.moveHistory.add(move);
        }
        if (this.endCheckAndPerform()) {
            return;
        }
        if (move != null) {
            MinesweeperEvents.executeEvent(new PlayerAfterMoveEvent(move));
        }
    }

    protected void removePlayer(MinesweeperPlayingPlayer pp) {
    }

    public void setMinesCount(int minesCount) {
        this.minesCount = minesCount;
    }

    public synchronized void callAI() {
        if (this.isAIDelay) {
            return;
        }
        if (this.isReplay) {
            return;
        }
        this.isAIDelay = true;
        if (this.getCurrentPlayer().isEliminated()) {
            return;
        }
        this.performAIMove();
    }

    protected void sendSound(MinesweeperMove move) {
    }

    private synchronized void performAIMove() {
        this.isAIDelay = false;
        if (this.isReplay) {
            return;
        }
        if (this.isGameOver()) {
            return;
        }
        if (this.getCurrentPlayer() == null) {
            return;
        }
        if (this.getCurrentPlayer().isEliminated()) {
            this.nextTurn();
            return;
        }
        if (this.getCurrentPlayer().isAI() && !this.endCheck()) {
            MinesweeperPlayingPlayer ai = this.getCurrentPlayer();
            MinesweeperAI theAI = ((MfeAI)this.getCurrentPlayer()).getAI();
            boolean moveResult = false;
            MinesweeperMove move = null;
            try {
                move = theAI.play();
                if (!theAI.getPlayingPlayer().isEliminated()) {
                    if (move != null) {
                        if (move.getPlayer() != theAI.getPlayingPlayer()) {
                            throw new AssertionError((Object)"Move player does not equals AI player.");
                        }
                        moveResult = this.performMove(move).isOK();
                    }
                } else {
                    moveResult = true;
                }
            }
            catch (Exception e) {
                MinesweeperEvents.executeEvent(new AIExceptionEvent(theAI, move, (Throwable)e, (MinesweeperMap)this));
                this.postMove(null);
            }
            catch (AssertionError e) {
                MinesweeperEvents.executeEvent(new AIExceptionEvent(theAI, move, (Throwable)((Object)e), (MinesweeperMap)this));
                this.postMove(null);
            }
            if (!moveResult) {
                MinesweeperEvents.executeEvent(new AIExceptionEvent(theAI, move, null, (MinesweeperMap)this));
                ((MfePlayer)theAI.getPlayingPlayer()).surrender();
                this.postMove(null);
            }
        }
        if (this.getCurrentPlayer() == null || !this.getCurrentPlayer().isAI() || !this.endCheck()) {
            // empty if block
        }
    }

    public int getFieldWidth() {
        return this.mapWidth;
    }

    public int getFieldHeight() {
        return this.mapHeight;
    }

    public MinesweeperField getPosition(int x, int y) {
        if (this.map == null) {
            return null;
        }
        if (x < 0) {
            return null;
        }
        if (y < 0) {
            return null;
        }
        if (x >= this.mapWidth) {
            return null;
        }
        if (y >= this.mapHeight) {
            return null;
        }
        return this.map.get(x).get(y);
    }

    public List<MinesweeperPlayingPlayer> getPlayingPlayers() {
        return new ArrayList<MinesweeperPlayingPlayer>(this.playingPlayers);
    }

    public List<MinesweeperPlayingPlayer> getRemainingPlayers() {
        ArrayList<MinesweeperPlayingPlayer> list = new ArrayList<MinesweeperPlayingPlayer>();
        for (MinesweeperPlayingPlayer pp : this.getPlayingPlayers()) {
            if (pp.isEliminated()) continue;
            list.add(pp);
        }
        return list;
    }

    public int getMinesCount() {
        return this.minesCount;
    }

    public int getMinesLeft() {
        int left = this.getMinesCount();
        for (MinesweeperPlayingPlayer player : this.playingPlayers) {
            left -= player.getScore();
        }
        return left;
    }

    public List<MinesweeperField> getAllUnclickedFields() {
        ArrayList<MinesweeperField> result = new ArrayList<MinesweeperField>();
        Iterator<MinesweeperField> iterator = this.iterator();
        while (iterator.hasNext()) {
            MinesweeperField mf = iterator.next();
            if (mf.isClicked()) continue;
            result.add(mf);
        }
        return result;
    }

    public MinesweeperPlayingPlayer getPlayingPlayer(MinesweeperPlayer player) {
        for (MinesweeperPlayingPlayer pp : this.getPlayingPlayers()) {
            if (!pp.getPlayer().equals(player)) continue;
            return pp;
        }
        return null;
    }

    public MinesweeperPlayingPlayer getPlayingPlayer(String name) {
        for (MinesweeperPlayingPlayer player : this.playingPlayers) {
            if (!player.getName().contentEquals(name)) continue;
            return player;
        }
        return null;
    }

    public MinesweeperPlayingPlayer getCurrentPlayer() {
        if (this.playingPlayers.size() <= this.playerTurn) {
            return null;
        }
        return this.playingPlayers.get(this.playerTurn);
    }

    public int getPlayerTurn() {
        return this.playerTurn;
    }

    public int getPotentialWinnerCount() {
        int i = 0;
        this.eliminatePlayers();
        for (MinesweeperPlayingPlayer player : this.playingPlayers) {
            if (player.isEliminated()) continue;
            ++i;
        }
        return i;
    }

    public synchronized void nextTurn() {
        MinesweeperPlayingPlayer previousPlayer = this.getCurrentPlayer();
        int oldTurn = this.playerTurn;
        do {
            ++this.playerTurn;
            this.playerTurn %= this.playingPlayers.size();
        } while (this.getCurrentPlayer().isEliminated() && oldTurn != this.playerTurn);
        MinesweeperEvents.executeEvent(new GameTurnChangeEvent((MinesweeperMap)this, previousPlayer));
    }

    public boolean endCheckAndPerform() {
        if (!this.endCheck()) {
            return false;
        }
        if (this.gameIsEnding) {
            return true;
        }
        this.gameIsEnding = true;
        ArrayList<MinesweeperPlayingPlayer> allPlayers = new ArrayList<MinesweeperPlayingPlayer>(this.playingPlayers);
        for (MinesweeperPlayingPlayer pp : allPlayers) {
            if (pp.isEliminated()) continue;
            pp.eliminateWin();
        }
        MinesweeperEvents.executeEvent(new GameEndedEvent((MinesweeperMap)this));
        return true;
    }

    protected boolean endCheck() {
        return this.getPotentialWinnerCount() <= this.endGameWhenPlayersLeftCount || this.getMinesLeft() == 0;
    }

    public boolean isActionMode() {
        return this.actionMode;
    }

    public void setActionMode(boolean actionMode) {
        this.actionMode = actionMode;
    }

    public void clear() {
        this.moveHistory.clear();
        for (MinesweeperPlayingPlayer player : this.getPlayingPlayers()) {
            player.changeScore(-player.getScore());
        }
        Iterator<MinesweeperPlayingPlayer> iterator = this.iterator();
        while (iterator.hasNext()) {
            MinesweeperField field = (MinesweeperField)iterator.next();
            field.setMine(false);
            field.setValue(0);
            field.inactivate();
        }
    }

    private void eliminatePlayers() {
        int currentPointCap = Integer.MIN_VALUE;
        for (MinesweeperPlayingPlayer player : this.getPlayingPlayers()) {
            if (currentPointCap >= player.getScore()) continue;
            currentPointCap = player.getScore();
        }
        for (MinesweeperPlayingPlayer pp : this.getPlayingPlayers()) {
            if (pp.isEliminated() || MinesweeperEvents.executeEvent(new PlayerEliminateCheckEvent(pp.getMap(), pp)).isCancelled() || pp.isEliminated() || pp.hasMostScore() || this.getMinesLeft() + pp.getScore() >= currentPointCap) continue;
            pp.eliminateLoss();
        }
    }

    void addSpecialMove(MinesweeperPlayingPlayer player, String moveInfo) {
        this.moveHistory.add(new SpecialMove(player, moveInfo));
    }

    public void setCurrentPlayer(MinesweeperPlayingPlayer player) {
        this.setCurrentPlayerTurn(player.getIndex());
    }

    public void setCurrentPlayerTurn(int playerIndex) {
        if (playerIndex >= this.playingPlayers.size()) {
            throw new IllegalArgumentException("Player index " + playerIndex + " is out of range. Size " + this.playingPlayers.size());
        }
        MinesweeperPlayingPlayer lastPlayer = this.getCurrentPlayer();
        this.playerTurn = playerIndex;
        MinesweeperEvents.executeEvent(new GameTurnChangeEvent((MinesweeperMap)this, lastPlayer));
    }

    public List<MinesweeperField> getAllFields() {
        ArrayList<MinesweeperField> fields = new ArrayList<MinesweeperField>();
        Iterator<MinesweeperField> iterator = this.iterator();
        while (iterator.hasNext()) {
            MinesweeperField ff = iterator.next();
            fields.add(ff);
        }
        return fields;
    }

    public boolean isDraw() {
        int resultPos1 = 0;
        for (MinesweeperPlayingPlayer pp : this.getPlayingPlayers()) {
            if (!pp.isEliminated() || pp.getResultPosition() != 1) continue;
            ++resultPos1;
        }
        return resultPos1 == 2;
    }

    public boolean isGameOver() {
        if (this.getPlayingPlayers().isEmpty()) {
            return false;
        }
        return this.getPlayersLeftCount() <= this.endGameWhenPlayersLeftCount;
    }

    public int getPlayersLeftCount() {
        int i = 0;
        for (MinesweeperPlayingPlayer pp : this.playingPlayers) {
            if (pp.isEliminated()) continue;
            ++i;
        }
        return i;
    }

    public Iterator<MinesweeperField> iterator() {
        return new MapListIterator<MinesweeperField>(this.map);
    }

    public Iterable<MinesweeperField> getIteration() {
        return this;
    }

    public String saveMap() {
        String str = "";
        for (int yy = 0; yy < this.getFieldHeight(); ++yy) {
            String st = "";
            for (int xx = 0; xx < this.getFieldWidth(); ++xx) {
                MinesweeperField field = this.getPosition(xx, yy);
                String fieldString = "";
                fieldString = !field.isClicked() ? (field.isMine() ? "x" : "_") : (field.isBlocked() ? ":" : (field.isMine() ? (field.getWhoClicked() == null ? "*" : "" + (char)(97 + field.getWhoClicked().getIndex())) : Integer.toString(field.getValue(), 16)));
                st = st + fieldString;
            }
            str = str + st;
            if (yy >= this.getFieldHeight() - 1) continue;
            str = str + "-";
        }
        return str;
    }

    public String[] saveMapMultiline() {
        return this.saveMap().split("-");
    }

    public MinesweeperMap loadMap(String data) {
        this.clear();
        int xsize = 16;
        boolean doInitFields = false;
        int xx = 0;
        int yy = 0;
        String str2 = data.replace(';', '&');
        int strlen = str2.length();
        for (int i = 0; i < strlen; ++i) {
            char c = str2.charAt(i);
            if (c == '\t') continue;
            if (c == '&' || c == '[') break;
            if (c == ' ') continue;
            if (c == '\r' || c == '-') {
                if (xx >= 1) {
                    ++yy;
                }
                xx = 0;
                continue;
            }
            if (xsize > 0 && xx >= xsize) {
                ++yy;
                xx = 0;
            }
            if (c == '\n') {
                if (xx >= 1) {
                    ++yy;
                }
                xx = 0;
                continue;
            }
            MinesweeperField f = this.getPosition(xx, yy);
            if (c == '_' || c == 'w' || c == '?') {
                f.inactivate();
            } else if (c == ':') {
                f.setBlocked(true);
            } else {
                if (f == null) {
                    throw new NullPointerException("f for " + xx + ", " + yy + " is null");
                }
                if (c == 'x') {
                    f.setMine(true);
                    doInitFields = true;
                } else if (c >= 'a' && c <= 'h' || c == '*') {
                    f.setMine(true);
                    if (c == '*') {
                        f.activate((MinesweeperPlayingPlayer)null);
                    } else {
                        f.activate(this.getPlayingPlayers().get(c - 97));
                    }
                }
                if (!f.isMine() && c >= '0' && c <= '9') {
                    f.setValue(c - 48);
                }
                if (c != 'x' && !f.isClicked()) {
                    f.activate();
                }
            }
            ++xx;
        }
        if (doInitFields) {
            this.initFields();
        }
        this.sendUpdateToPlayers();
        return this;
    }

    @Deprecated
    public void copyFrom(MinesweeperMap game) {
        Iterator<MinesweeperField> iterator = this.iterator();
        while (iterator.hasNext()) {
            MinesweeperField mf = iterator.next();
            mf.copyFrom(game.getPosition(mf.getX(), mf.getY()));
        }
    }

    public MinesweeperField getPosition(String xy) {
        int x = Integer.parseInt(xy.substring(0, xy.length() / 2), 16);
        int y = Integer.parseInt(xy.substring(xy.length() / 2), 16);
        return this.getPosition(x, y);
    }

    public void setMinePositions(String minepos, int charsPerPos) {
        this.clear();
        if (minepos == null) {
            this.generate();
            return;
        }
        if (minepos.startsWith("*")) {
            throw new IllegalArgumentException("Decrypt the string before passing it to setMinePositions.");
        }
        while (!minepos.isEmpty()) {
            MinesweeperField pos = this.getPosition(minepos.substring(0, charsPerPos));
            pos.setMine(true);
            minepos = minepos.substring(charsPerPos);
        }
        this.postGenerate();
    }

    public final void sendUpdateToPlayers() {
        MinesweeperEvents.executeEvent(new GameSendUpdateEvent((MinesweeperMap)this));
    }

    public void setMinePositions(String minepos) {
        int charsPerPos = 2;
        if (this.getFieldWidth() > 16) {
            throw new IllegalStateException("Error: Map Width  is more than 16 and charsPerPos is not defined (using default 2).");
        }
        if (this.getFieldHeight() > 16) {
            throw new IllegalStateException("Error: Map Height is more than 16 and charsPerPos is not defined (using default 2).");
        }
        this.setMinePositions(minepos, charsPerPos);
    }

    public MinesweeperField newTile(MfeMap map, int x, int y) {
        return new MfeField(this, x, y);
    }

    public MoveAllowedState performClicks(String clicks) {
        while (clicks.length() > 0) {
            MinesweeperMove move;
            try {
                String moveString = clicks.substring(0, GameReplay.CHARS_PER_CLICK);
                if (moveString.startsWith("#")) {
                    this.handleSpecialMove(moveString);
                }
                move = this.getCurrentPlayer().createMove(moveString);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Unable to perform clicks for game " + this, e);
            }
            clicks = clicks.substring(GameReplay.CHARS_PER_CLICK);
            MoveAllowedState moveResult = this.performMove(move);
            if (moveResult.isOK()) continue;
            return moveResult;
        }
        return MoveAllowedState.OK;
    }

    private void handleSpecialMove(String moveString) {
        MfePlayer pp;
        int playerIndex;
        try {
            playerIndex = Integer.parseInt(UtilZomisUtils.substr((String)moveString, (int)-1)) - 1;
        }
        catch (NumberFormatException e) {
            playerIndex = -1;
        }
        if (moveString.startsWith("#S")) {
            pp = playerIndex == -1 ? (MfePlayer)this.getCurrentPlayer() : (MfePlayer)this.getPlayingPlayers().get(playerIndex);
            pp.surrender();
        }
        if (moveString.startsWith("#W")) {
            pp = playerIndex == -1 ? (MfePlayer)this.getCurrentPlayer() : (MfePlayer)this.getPlayingPlayers().get(playerIndex);
            pp.walkover();
        }
        if (moveString.startsWith("#D")) {
            if (playerIndex == -1) {
                pp = null;
                for (MinesweeperPlayingPlayer pp2 : this.getPlayingPlayers()) {
                    if (((MfePlayer)pp2).hasDraw()) continue;
                    pp = (MfePlayer)this.getCurrentPlayer();
                }
            } else {
                pp = (MfePlayer)this.getPlayingPlayers().get(playerIndex);
            }
            if (pp != null) {
                pp.proposeDraw();
            }
        }
    }

    public MinesweeperMove createMove(MinesweeperPlayingPlayer player, MinesweeperWeapon weapon, MinesweeperField field) {
        return new MfeMove(player, player == null ? weapon : player.hasWeapon(weapon), field);
    }

    public final boolean hasPlugin(MinesweeperPlugin plugin) {
        return this.activePlugins.contains(plugin);
    }

    public final void addPlugin(MinesweeperPlugin plugin) {
        this.activePlugins.add(plugin);
    }

    public final List<MinesweeperPlugin> getActivePlugins() {
        return new ArrayList<MinesweeperPlugin>(this.activePlugins);
    }

    public MapFactory getMapFactory() {
        return MapFactoryImpl.newFactory();
    }

    public MoveAllowedState performMove(MinesweeperMove move) {
        if (move instanceof SpecialMove) {
            return ((SpecialMove)move).performSpecialMove();
        }
        CancellableEvent event = (CancellableEvent)MinesweeperEvents.executeEvent(new PlayerMoveEvent(move));
        if (event.isCancelled()) {
            return MoveAllowedState.DENIED_BY_PLUGIN;
        }
        MinesweeperWeapon weapon = move.getPlayer().hasWeapon(move.getWeapon());
        if (weapon == null) {
            return MoveAllowedState.WEAPON_NOT_FOUND;
        }
        if (!move.getMoveAllowedState().isOK()) {
            return move.getMoveAllowedState();
        }
        if (!weapon.canUseAt(move.getPlayer(), move.getMovePosition())) {
            return move.getMoveAllowedState();
        }
        boolean useOK = move.getWeapon().useAt(move);
        if (!useOK && move.getPlayer().getPlayer() != null) {
            return MoveAllowedState.MOVE_FAILED;
        }
        if (!useOK) {
            return MoveAllowedState.MOVE_FAILED;
        }
        this.postMove(move);
        return MoveAllowedState.OK;
    }

    public MinesweeperField getPosition(MinesweeperField field) {
        return this.getPosition(field.getX(), field.getY());
    }

    public MinesweeperReplay createReplay() {
        MinesweeperMap mmap = MapUtils.copyBase(this);
        return new GameReplay(MapUtils.getMinesString(this), MapUtils.getClickString(this), mmap);
    }
}

