/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.game.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import net.zomis.minesweeper.api.FieldType;
import net.zomis.minesweeper.events.game.FieldActivatedEvent;
import net.zomis.minesweeper.events.game.FieldUpdateEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.game.model.MfeMap;
import net.zomis.minesweeper.game.model.MinesweeperEvents;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public class MfeField
implements MinesweeperField {
    private final MfeMap map;
    private final int x;
    private final int y;
    private int mineValue = 0;
    private int neighboringMines = 0;
    private MinesweeperPlayingPlayer clickedBy = null;
    private boolean clicked = false;
    private final Collection<MinesweeperField> neighbors;
    private final Collection<MinesweeperField> invertedNeighbors;
    private boolean blocked;

    public MfeField(MfeMap map, int x, int y) {
        this.map = map;
        this.x = x;
        this.y = y;
        this.neighbors = new HashSet<MinesweeperField>();
        this.invertedNeighbors = new HashSet<MinesweeperField>();
    }

    public boolean isClicked() {
        return this.clicked || this.isBlocked();
    }

    public MinesweeperPlayingPlayer getWhoClicked() {
        return this.clickedBy;
    }

    public boolean isDiscoveredMine() {
        return this.isClicked() && this.mineValue != 0;
    }

    public int getKnownValue() {
        if (!this.isClicked() || this.isMine()) {
            return Integer.MIN_VALUE;
        }
        return this.neighboringMines;
    }

    private void activate(MinesweeperPlayingPlayer player, MinesweeperMove moveInfo) {
        if (this.isMine() && this.clickedBy != null) {
            this.map.performScoreChange(this.clickedBy, -this.mineValue);
        }
        this.clicked = true;
        this.clickedBy = player;
        MinesweeperEvents.executeEvent(new FieldActivatedEvent((MinesweeperField)this, moveInfo));
        if (this.isMine() && this.clickedBy != null && this.getMap() instanceof MfeMap) {
            ((MfeMap)this.getMap()).performScoreChange(this.clickedBy, this.mineValue);
        }
    }

    public void activate(MinesweeperPlayingPlayer player) {
        this.activate(player, player == null ? null : player.createMove((MinesweeperWeapon)null, (MinesweeperField)this));
    }

    public void activate(MinesweeperMove moveInfo) {
        this.activate(moveInfo == null ? null : moveInfo.getPlayer(), moveInfo);
    }

    public void activate() {
        this.activate(null, null);
    }

    public void inactivate() {
        this.clicked = false;
        if (this.clickedBy != null && this.isMine()) {
            this.clickedBy.changeScore(-this.getMineValue());
        }
        this.clickedBy = null;
    }

    public Collection<MinesweeperField> getNeighbors() {
        return new ArrayList<MinesweeperField>(this.neighbors);
    }

    public void addNeighbor(MinesweeperField field) {
        if (field != null && field != this) {
            this.neighbors.add(field);
            ((MfeField)field).invertedNeighbors.add(this);
        }
    }

    public boolean removeNeighbor(MinesweeperField field) {
        ((MfeField)field).invertedNeighbors.remove(this);
        return this.neighbors.remove(field);
    }

    public MinesweeperMap getMap() {
        return this.map;
    }

    public void init() {
        int value = 0;
        for (MinesweeperField field : this.neighbors) {
            value += field.getMineValue();
        }
        this.neighboringMines = value;
    }

    public boolean isMine() {
        return this.getMineValue() != 0;
    }

    public int getValue() {
        return this.neighboringMines;
    }

    public int getMineValue() {
        return this.mineValue;
    }

    public void setMine(boolean mine) {
        this.mineValue = mine ? 1 : 0;
    }

    public String getCoordinate() {
        int radix = 16;
        return Integer.toString(this.getX(), radix) + Integer.toString(this.getY(), radix);
    }

    public void addNeighbor(int dx, int dy) {
        this.addNeighbor(this.getMap().getPosition(this.getX() + dx, this.getY() + dy));
    }

    public String toString() {
        if (this.isClicked()) {
            return this.getCoordinate() + "=" + (this.isBlocked() ? "#" : (this.isMine() ? "*" : Integer.valueOf(this.getValue())));
        }
        return this.getCoordinate();
    }

    public void setValue(int value) {
        this.neighboringMines = value;
    }

    public Collection<MinesweeperField> getInvertedNeighbors() {
        return new ArrayList<MinesweeperField>(this.invertedNeighbors);
    }

    public MinesweeperField getRelativePosition(int deltaX, int deltaY) {
        int newX = this.x + deltaX;
        int newY = this.y + deltaY;
        if (newX < 0 || newY < 0) {
            return null;
        }
        if (newX >= this.map.getFieldWidth() || newY >= this.map.getFieldHeight()) {
            return null;
        }
        return this.map.getPosition(newX, newY);
    }

    public void copyFrom(MinesweeperField position) {
        this.clicked = position.isClicked();
        this.clickedBy = position.getWhoClicked() == null ? null : (MinesweeperPlayingPlayer)this.getMap().getPlayingPlayers().get(position.getWhoClicked().getIndex());
        this.mineValue = position.getMineValue();
        this.setBlocked(position.isBlocked());
        this.neighboringMines = position.getValue();
        Iterator<MinesweeperField> it = this.getNeighbors().iterator();
        while (it.hasNext()) {
            this.removeNeighbor(it.next());
        }
        for (MinesweeperField newNeighbor : position.getNeighbors()) {
            this.addNeighbor(this.getMap().getPosition(newNeighbor.getX(), newNeighbor.getY()));
        }
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    @Deprecated
    public int getFieldType() {
        return this.isBlocked() ? 2 : (this.isClicked() ? 1 : 0);
    }

    public void sendInfoToPlayers() {
        MinesweeperEvents.executeEvent(new FieldUpdateEvent((MinesweeperField)this));
    }

    public void sendInfoToPlayer(MinesweeperPlayingPlayer player) {
        if (player.getPlayer() == null) {
            return;
        }
        player.getPlayer().sendFieldInfo((MinesweeperField)this, this.getWhoClicked(), false);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MinesweeperField)) {
            return false;
        }
        MinesweeperField ff = (MinesweeperField)obj;
        return this.getX() == ff.getX() && this.getY() == ff.getY();
    }

    public FieldType getFieldStyle() {
        return this.isBlocked() ? FieldType.BLOCKED : (this.isClicked() ? FieldType.CLICKED : FieldType.UNCLICKED);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

