/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.game.model;

import java.util.ArrayList;
import java.util.List;
import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.game.MinesweeperReplay;
import net.zomis.minesweeper.game.model.MfeMap;

public class GameReplay
implements MinesweeperReplay {
    public static int CHARS_PER_POS = 2;
    public static int CHARS_PER_CLICK = CHARS_PER_POS + 1;
    private final MinesweeperGame game;
    private final MinesweeperMap map;
    private final String clicksString;
    private final String minepos;
    private final List<MinesweeperMove> moves;
    private int position = 0;

    public GameReplay(String minepos, String clicksString, MinesweeperMap map) {
        this.game = map instanceof MinesweeperGame ? (MinesweeperGame)map : null;
        this.map = map;
        this.map.setMinePositions(minepos);
        this.minepos = minepos;
        this.clicksString = clicksString;
        this.moves = new ArrayList<MinesweeperMove>(this.getMoveCount());
        while (this.hasMoreMoves()) {
            this.moves.add(this.getMoveAt(this.position));
            this.nextMove();
        }
        this.setPosition(0);
    }

    private MinesweeperMove getMoveAt(int position) {
        String click = UtilZomisUtils.substr((String)this.clicksString, (int)(position * CHARS_PER_CLICK), (int)CHARS_PER_CLICK);
        if (click.length() < CHARS_PER_CLICK) {
            return null;
        }
        return this.getMap().getCurrentPlayer().createMove(click);
    }

    public boolean hasMoreMoves() {
        return this.position < this.getMoveCount();
    }

    public int getMoveCount() {
        return this.clicksString.length() / CHARS_PER_CLICK;
    }

    public boolean nextMove() {
        String click = UtilZomisUtils.substr((String)this.clicksString, (int)(this.getPosition() * CHARS_PER_CLICK), (int)CHARS_PER_CLICK);
        if (click.length() < CHARS_PER_CLICK) {
            return false;
        }
        ++this.position;
        ((MfeMap)this.map).performClicks(click);
        return true;
    }

    public void previousMove() {
        this.setPosition(this.getPosition() - 1);
    }

    public void rewind() {
        this.position = 0;
        this.map.setMinePositions(this.minepos, CHARS_PER_POS);
        for (MinesweeperPlayingPlayer pp : this.map.getPlayingPlayers()) {
            pp.reset();
        }
        this.map.setCurrentPlayerTurn(0);
        if (this.game != null) {
            this.game.sendUpdateToPlayers();
        }
    }

    public MinesweeperGame getGame() {
        return this.game;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        if (position < 0) {
            throw new IllegalArgumentException("Position cannot be negative.");
        }
        if (position < this.getPosition()) {
            this.rewind();
            for (int i = 0; i < position; ++i) {
                this.nextMove();
            }
        } else if (position > this.getPosition()) {
            for (int i = this.getPosition(); i < position; ++i) {
                this.nextMove();
            }
        }
        this.position = position;
    }

    public MinesweeperMap getMap() {
        return this.map;
    }

    public List<MinesweeperMove> getMoves() {
        return new ArrayList<MinesweeperMove>(this.moves);
    }
}

