/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.game.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.zomis.UtilZomisList;
import net.zomis.minesweeper.api.MinesweeperAI;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.events.game.GameScoreChanged;
import net.zomis.minesweeper.events.game.PlayerEliminatedEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.game.model.GameReplay;
import net.zomis.minesweeper.game.model.MfeMap;
import net.zomis.minesweeper.game.model.MfeMove;
import net.zomis.minesweeper.game.model.MinesweeperEvents;
import net.zomis.minesweeper.game.model.SpecialMove;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MfePlayer
implements MinesweeperPlayingPlayer {
    private static final Logger logger = LogManager.getLogger((String)"MfePlayer");
    private final List<MinesweeperWeapon> weapons;
    private final MinesweeperMap map;
    private final int index;
    private MinesweeperPlayer player;
    private int score;
    private boolean gameOver;
    private int resultPosition;
    private boolean didSurrender;
    private boolean didWalkover;

    public MfePlayer(MinesweeperMap map, MinesweeperPlayer player, int index) {
        this.map = map;
        this.player = player;
        this.weapons = new ArrayList<MinesweeperWeapon>();
        this.index = index;
        this.reset();
    }

    public void reset() {
        for (MinesweeperWeapon weapons : this.weapons) {
            weapons.resetUsage();
        }
        this.score = 0;
        this.gameOver = false;
        this.resultPosition = -1;
        this.didSurrender = false;
        this.didWalkover = false;
    }

    public MinesweeperPlayer getPlayer() {
        return this.player;
    }

    public String getName() {
        if (this.player == null) {
            return "Player " + this.getIndex();
        }
        if (this.isAI()) {
            return this.player.getName().substring(1);
        }
        return this.player.getName();
    }

    public MinesweeperMap getMap() {
        return this.map;
    }

    public void giveWeapon(MinesweeperWeapon weapon) {
        this.weapons.add(weapon);
    }

    public boolean canUseWeapon(String weaponType) {
        MinesweeperWeapon weapon = this.getWeapon(weaponType);
        if (weapon == null) {
            return false;
        }
        return weapon.canUse((MinesweeperPlayingPlayer)this);
    }

    public int getScore() {
        return this.score;
    }

    public void changeScore(int change) {
        if (change == 0) {
            return;
        }
        int old = this.getScore();
        this.score += change;
        MinesweeperEvents.executeEvent(new GameScoreChanged(this.getMap(), (MinesweeperPlayingPlayer)this, old));
    }

    public MinesweeperWeapon hasWeapon(MinesweeperWeapon weapon) {
        for (MinesweeperWeapon weap : this.weapons) {
            if (!weap.equals(weapon)) continue;
            return weap;
        }
        return null;
    }

    public boolean isMyTurn() {
        return this.getIndex() == this.getMap().getPlayerTurn() || this.getMap().isActionMode();
    }

    public boolean hasMostScore() {
        for (MinesweeperPlayingPlayer player : this.getMap().getPlayingPlayers()) {
            if (player.getScore() <= this.getScore()) continue;
            return false;
        }
        return true;
    }

    public boolean isEliminated() {
        return this.gameOver;
    }

    public int getIndex() {
        return this.index;
    }

    public void eliminateLoss() {
        this.eliminate(true);
    }

    public void eliminateWin() {
        this.eliminate(false);
    }

    private void eliminate(boolean lost) {
        int playerResultPosition = this.getMap().getPlayingPlayers().size() + 1;
        if (!lost) {
            playerResultPosition = 0;
        }
        boolean posTaken = false;
        block0: do {
            posTaken = false;
            playerResultPosition += lost ? -1 : 1;
            for (MinesweeperPlayingPlayer pp : this.getMap().getPlayingPlayers()) {
                if (!pp.isEliminated() || pp.getResultPosition() != playerResultPosition) continue;
                posTaken = true;
                continue block0;
            }
        } while (posTaken && playerResultPosition >= -25 && playerResultPosition < 25);
        this.eliminate(playerResultPosition);
    }

    public void eliminate(int resultPosition) {
        if (this.isEliminated()) {
            return;
        }
        logger.info((Object)("Player " + this + " eliminated! " + resultPosition));
        this.gameOver = true;
        this.resultPosition = resultPosition;
        MinesweeperEvents.executeEvent(new PlayerEliminatedEvent((MinesweeperPlayingPlayer)this));
        if (this.getMap().getPlayerTurn() == this.getIndex()) {
            this.getMap().nextTurn();
        }
    }

    public String toString() {
        return String.format("%d: %s (%d)", this.getIndex(), this.player, this.getScore());
    }

    public boolean isAI() {
        return false;
    }

    public int getResultPosition() {
        return this.resultPosition;
    }

    public List<MinesweeperWeapon> getWeapons() {
        return new ArrayList<MinesweeperWeapon>(this.weapons);
    }

    public List<MinesweeperMove> getMoves() {
        List myMoves = this.getMap().getMoveHistory();
        UtilZomisList.filter((Collection)myMoves, (UtilZomisList.FilterInterface)new MyMovesFilter(this));
        return myMoves;
    }

    public void updatePlayer(MinesweeperPlayer old, MinesweeperPlayer real) {
        if (this.player == null) {
            return;
        }
        if (this.player.equals(old)) {
            this.player = real;
        }
    }

    public MinesweeperWeapon getWeapon(String weaponType) {
        for (MinesweeperWeapon weapon : this.weapons) {
            if (!weapon.getWeaponType().contentEquals(weaponType)) continue;
            return weapon;
        }
        return null;
    }

    public void surrender() {
        this.didSurrender = true;
        ((MfeMap)this.getMap()).addSpecialMove(this, "#S" + (this.getIndex() + 1));
        this.eliminateLoss();
    }

    public void walkover() {
        this.didWalkover = true;
        ((MfeMap)this.getMap()).addSpecialMove(this, "#W" + (this.getIndex() + 1));
        this.eliminateLoss();
    }

    public boolean proposeDraw() {
        if (!MfePlayer.drawPossible(this.map)) {
            return false;
        }
        if (this.hasDraw()) {
            return true;
        }
        boolean drawAgreement = true;
        ((MfeMap)this.getMap()).addSpecialMove(this, "#D" + (this.getIndex() + 1));
        if (this.getMap().getPlayersLeftCount() == 2) {
            for (MinesweeperPlayingPlayer pp : this.getMap().getPlayingPlayers()) {
                if (pp.getIndex() == this.getIndex() || !pp.isAI() || ((MfePlayer)pp).hasDraw() || !pp.getAI().agreeDraw()) continue;
                pp.proposeDraw();
            }
        }
        for (MinesweeperPlayingPlayer pp : this.getMap().getPlayingPlayers()) {
            if (pp == this || pp.isEliminated() || ((MfePlayer)pp).hasDraw()) continue;
            drawAgreement = false;
            break;
        }
        if (drawAgreement) {
            ((MfeMap)this.getMap()).addSpecialMove(this, "#DW");
            for (MinesweeperPlayingPlayer pp : this.getMap().getPlayingPlayers()) {
                if (pp.isEliminated()) continue;
                pp.eliminate(1);
            }
        }
        return true;
    }

    public boolean hasSurrender() {
        return this.didSurrender;
    }

    public boolean hasWalkover() {
        return this.didWalkover;
    }

    public static boolean drawPossible(MinesweeperMap game) {
        return game.getMinesLeft() <= game.getMinesCount() - 20;
    }

    public boolean hasDraw() {
        List history = this.getMap().getMoveHistory();
        for (int i = history.size() - 1; i >= 0; --i) {
            if (history.get(i) instanceof SpecialMove) {
                SpecialMove spec = (SpecialMove)history.get(i);
                if (!spec.getType().equals("D")) {
                    return false;
                }
                if (spec.getPlayerIndex() != this.getIndex()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public MinesweeperAI getAI() {
        return null;
    }

    public MinesweeperMove createMove(String weaponType, MinesweeperField field) {
        return this.createMove(this.getWeapon(weaponType), field);
    }

    public MinesweeperMove createMove(MinesweeperWeapon weapon, MinesweeperField field) {
        return new MfeMove((MinesweeperPlayingPlayer)this, this.hasWeapon(weapon), field);
    }

    public MinesweeperMove createMove(String moveData) {
        if (moveData.length() != GameReplay.CHARS_PER_CLICK) {
            throw new IllegalArgumentException("Move data must have length " + GameReplay.CHARS_PER_CLICK + " data was " + moveData);
        }
        if (moveData.startsWith("#")) {
            return new SpecialMove(this, moveData);
        }
        if (moveData.contentEquals("W##")) {
            return new SpecialMove(this, "#W" + (this.getIndex() + 1));
        }
        String xy = moveData.substring(1);
        String x = xy.substring(0, xy.length() / 2);
        String y = xy.substring(xy.length() / 2);
        try {
            return new MfeMove((MinesweeperPlayingPlayer)this, this.getWeapon(moveData.substring(0, 1)), this.getMap().getPosition(Integer.parseInt(x, 16), Integer.parseInt(y, 16)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Position-part of string is not parsable. Expected weapontype + Hexadecimal position (x and y). Found: " + moveData);
        }
    }

    private static class MyMovesFilter
    implements UtilZomisList.FilterInterface<MinesweeperMove> {
        private MfePlayer pp;

        MyMovesFilter(MfePlayer pp) {
            this.pp = pp;
        }

        public boolean shouldKeep(MinesweeperMove obj) {
            return obj.getPlayer().equals(this.pp);
        }
    }
}

