/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.player;

import net.zomis.minesweeper.api.FieldInfo;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.Metadata;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperServer;
import net.zomis.minesweeper.api.UserClient;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.player.PlayerHelper;

public class SimplePlayer
implements MinesweeperPlayer {
    private String name;
    private Double rating;
    private PlayerHelper frame;
    private Metadata metadata;
    private int budget;

    public SimplePlayer(PlayerHelper helper) {
        this.frame = helper;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public MinesweeperGame getGame() {
        return null;
    }

    public MinesweeperGame getPlayingGame() {
        return null;
    }

    public Integer getGameID() {
        return -42;
    }

    public MinesweeperGame getObservingGame() {
        return null;
    }

    public Double getRating() {
        return this.rating;
    }

    public boolean hasAccessToCommand(String command) {
        return true;
    }

    @Deprecated
    public boolean hasPermission(int permission) {
        return true;
    }

    public boolean isAI() {
        return false;
    }

    public boolean isGuest() {
        return false;
    }

    public boolean isInGame() {
        return true;
    }

    public boolean isObserving() {
        return false;
    }

    public boolean isOnline() {
        return true;
    }

    public boolean isRealPlayer() {
        return true;
    }

    public boolean isServer() {
        return false;
    }

    public boolean isTemporaryPlayer() {
        return false;
    }

    public boolean sendChat(String message) {
        this.frame.sendText(message + "\n");
        return true;
    }

    public void sendChatBy(String message, MinesweeperPlayer from) {
        this.sendChatBy(message, from, from == null ? null : from.getChatColor());
    }

    public void sendChatBy(String message, MinesweeperPlayer from, Integer chatColor) {
        this.sendChat((from == null ? "" : from.getName() + ": ") + message);
    }

    public boolean sendChat(String message, Integer chatColor) {
        return false;
    }

    public void sendFieldImage(MinesweeperField field, String url) {
        throw new UnsupportedOperationException();
    }

    public MinesweeperServer getServer() {
        return null;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void sendFieldInfo(MinesweeperField field, MinesweeperPlayingPlayer player, boolean highlight) {
        throw new UnsupportedOperationException();
    }

    public void sendAlert(String alertMessage) {
        this.frame.alert(alertMessage);
    }

    public boolean isClientAndroid() {
        return false;
    }

    public boolean isClientFlash() {
        return false;
    }

    public boolean hasMineCoins(int amount) {
        return this.budget >= amount;
    }

    public int getMineCoins() {
        return this.budget;
    }

    public boolean addMineCoins(int amount) {
        if (amount < 0 && !this.hasMineCoins(amount)) {
            return false;
        }
        this.budget += amount;
        return true;
    }

    public Integer getChatColor() {
        return null;
    }

    public void sendFieldInfo(MinesweeperField fieldPosition, MinesweeperPlayingPlayer player, int fieldType, boolean isMine, int value, boolean highlight) {
        throw new UnsupportedOperationException();
    }

    public Invite createInvitation(String[] plugins) {
        throw new UnsupportedOperationException();
    }

    public void performCommand(String command) {
        throw new UnsupportedOperationException();
    }

    public boolean hasPermission(String requiredPermission) {
        return true;
    }

    public String getFacebookUsername() {
        return null;
    }

    public int getUserId() {
        return -41;
    }

    public UserClient getClient() {
        return UserClient.JAVA;
    }

    public MinesweeperMap getMap() {
        return this.frame.getMap();
    }

    public void refreshMapView() {
        if (this.getMap() != null) {
            this.getMap().sendUpdateToPlayers();
        }
    }

    public String toString() {
        return this.getName();
    }

    public void sendFieldInfo(MinesweeperField fieldPosition, FieldInfo fieldInfo) {
        throw new UnsupportedOperationException();
    }

    public void setName(String name) {
        this.name = name;
    }
}

