/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.game.model;

import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.game.MoveAllowedState;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public class MfeMove
implements MinesweeperMove {
    private final MinesweeperWeapon weapon;
    private final MinesweeperField movePosition;
    private final MinesweeperPlayingPlayer player;
    private final String weaponType;
    private final MinesweeperMap map;

    public MinesweeperWeapon getWeapon() {
        return this.weapon;
    }

    public String getWeaponType() {
        if (this.weapon == null) {
            return this.weaponType;
        }
        return this.weapon.getWeaponType();
    }

    public MinesweeperMap getMap() {
        return this.map;
    }

    protected MfeMove(MinesweeperPlayingPlayer player, String weaponType, MinesweeperField field) {
        this.movePosition = field;
        this.weapon = null;
        this.weaponType = weaponType;
        this.player = player;
        this.map = field != null ? field.getMap() : player.getMap();
    }

    public MfeMove(MinesweeperPlayingPlayer player, MinesweeperWeapon weapon, MinesweeperField field) {
        this.movePosition = field;
        this.weapon = weapon;
        this.weaponType = this.weapon == null ? null : this.weapon.getWeaponType();
        this.player = player;
        this.map = field != null ? field.getMap() : player.getMap();
    }

    public MinesweeperField getMovePosition() {
        return this.movePosition;
    }

    public MoveAllowedState getMoveAllowedState() {
        if (this.player == null) {
            return MoveAllowedState.NO_PLAYER;
        }
        if (this.getWeapon() == null) {
            return MoveAllowedState.NO_WEAPON;
        }
        if (!this.getMap().isActionMode() && !this.getPlayer().isMyTurn()) {
            return MoveAllowedState.NOT_PLAYER_TURN;
        }
        if (!this.getWeapon().canUse(this.player)) {
            return MoveAllowedState.WEAPON_DENIED;
        }
        if (this.getMovePosition() != null && !this.getWeapon().canUseAt(this.getPlayer(), this.getMovePosition())) {
            return MoveAllowedState.WEAPON_POSITION_DENIED;
        }
        if (!this.getWeapon().canUseAt(this.getPlayer(), this.getMovePosition())) {
            return MoveAllowedState.WEAPON_POSITION_DENIED;
        }
        return MoveAllowedState.OK;
    }

    public int getX() {
        return this.movePosition != null ? this.movePosition.getX() : Integer.MIN_VALUE;
    }

    public int getY() {
        return this.movePosition != null ? this.movePosition.getY() : Integer.MIN_VALUE;
    }

    public MinesweeperPlayingPlayer getPlayer() {
        return this.player;
    }

    public String toString() {
        return "(Move@" + (this.movePosition != null ? this.movePosition.getCoordinate() : null) + " : " + this.getWeaponType() + " by " + this.getPlayer() + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MinesweeperMove)) {
            return false;
        }
        MinesweeperMove move = (MinesweeperMove)obj;
        return move.getPlayer().getIndex() == this.getPlayer().getIndex() && move.getMovePosition() == null ? this.getMovePosition() == null : move.getMovePosition().equals(this.getMovePosition()) && move.getWeaponType().contentEquals(this.getWeaponType());
    }

    public int hashCode() {
        int i = 0;
        i = 103 * i + this.getPlayer().getIndex();
        i = 103 * i + this.getWeaponType().hashCode();
        i = 103 * i + this.getX();
        i = 103 * i + this.getY();
        return i;
    }

    public String getMoveString() {
        return this.getWeaponType() + this.getMovePosition().getCoordinate();
    }

    public MinesweeperField getField() {
        return this.getMovePosition();
    }
}

