/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.game.model;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Random;
import net.zomis.minesweeper.api.AIHelper;
import net.zomis.minesweeper.api.MapFactory;
import net.zomis.minesweeper.api.MinesweeperAI;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.game.GameInitEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.game.model.HiddenMap;
import net.zomis.minesweeper.game.model.MfeAI;
import net.zomis.minesweeper.game.model.MfeMap;
import net.zomis.minesweeper.game.model.MfeMapImpl;
import net.zomis.minesweeper.game.model.MfePlayer;
import net.zomis.minesweeper.game.model.MinesweeperEvents;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;
import net.zomis.weapons.classic.BombWeapon;
import net.zomis.weapons.classic.ClickWeapon;

public class MapFactoryImpl
implements MapFactory {
    public static final int DEFAULT_PLAYER_COUNT = 2;
    private static final Random random = new Random();
    private MinesweeperMap map;
    private AIHelper aiHelper;
    private boolean loaded = false;

    public MapFactory setAIHelper(AIHelper aiHelper) {
        this.aiHelper = aiHelper;
        return this;
    }

    private MapFactoryImpl() {
        this.map = MapFactoryImpl.newStandardSizeAndNeighbors();
    }

    private MapFactoryImpl(int x, int y) {
        this.map = new MfeMapImpl();
        ((MfeMap)this.map).initMap(x, y);
    }

    private MapFactoryImpl(MinesweeperMap map) {
        this.map = map;
    }

    @Deprecated
    private static MinesweeperMap newStandardSizeAndNeighbors() {
        MfeMapImpl map = new MfeMapImpl();
        map.initMap(16, 16);
        Iterator iterator = map.iterator();
        while (iterator.hasNext()) {
            MinesweeperField ff = (MinesweeperField)iterator.next();
            for (int xx = -1; xx <= 1; ++xx) {
                for (int yy = -1; yy <= 1; ++yy) {
                    if (xx == 0 && yy == 0) continue;
                    ff.addNeighbor(xx, yy);
                }
            }
        }
        return map;
    }

    public MinesweeperMap map() {
        MinesweeperEvents.executeEvent(new GameInitEvent(this.map));
        if (!this.loaded) {
            int mcount = this.map.getMinesCount();
            this.map.generate(mcount, random);
        }
        return this.map;
    }

    public static MapFactory newFactory() {
        return new MapFactoryImpl();
    }

    public static MapFactory fromMap(MinesweeperMap map) {
        return new MapFactoryImpl(map);
    }

    public MapFactory withDefaultWeapons() {
        return this.withWeapons(ClickWeapon.class, BombWeapon.class);
    }

    public MinesweeperMap standard() {
        this.withPlayers(2 - this.map.getPlayingPlayers().size());
        this.withWeapons(ClickWeapon.class, BombWeapon.class);
        return this.map();
    }

    public MapFactory withWeapons(Class<?> ... weaponClasses) {
        if (this.map.getPlayingPlayers().isEmpty()) {
            throw new IllegalStateException("Players must be added before adding weapons");
        }
        for (Class<?> clz : weaponClasses) {
            if (MinesweeperWeapon.class.isAssignableFrom(clz)) continue;
            throw new IllegalArgumentException(clz.getCanonicalName() + " is not a MinesweeperWeapon.");
        }
        for (MinesweeperPlayingPlayer pp : this.map.getPlayingPlayers()) {
            for (Class<?> clz : weaponClasses) {
                MinesweeperWeapon weap;
                if (!MinesweeperWeapon.class.isAssignableFrom(clz)) continue;
                try {
                    weap = (MinesweeperWeapon)clz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                catch (SecurityException e) {
                    throw new RuntimeException(e);
                }
                pp.giveWeapon(weap);
            }
        }
        return this;
    }

    public MinesweeperMap hiddenMap(MinesweeperMap map) {
        HiddenMap hidden = new HiddenMap(map);
        hidden.initMap(map.getFieldWidth(), map.getFieldHeight());
        hidden.loadMap(map.saveMap());
        return hidden;
    }

    public MapFactory loadFrom(String str) {
        if (this.map.getPlayingPlayers().isEmpty()) {
            throw new IllegalStateException("Map must have players before it can be loaded from string");
        }
        this.loaded = true;
        this.map.generate();
        this.map.loadMap(str);
        return this;
    }

    @Deprecated
    public MapFactory copy(MinesweeperMap map) {
        throw new UnsupportedOperationException("deprecated");
    }

    public MapFactory withTwoPlayers() {
        return this.withPlayers(2);
    }

    public MapFactory withPlayers(int count) {
        for (int i = 0; i < count; ++i) {
            ((MfeMap)this.map).addPlayer(new MfePlayer(this.map, null, this.map.getPlayingPlayers().size()));
        }
        return this;
    }

    public MapFactory withAI(Class<? extends MinesweeperAI> aiClass, MinesweeperPlayer backingPlayer) {
        if (aiClass == null) {
            throw new IllegalArgumentException("AI class is null");
        }
        try {
            ((MfeMap)this.map).addPlayer(new MfeAI(this.map, backingPlayer, aiClass.getConstructor(MinesweeperPlayingPlayer.class), this.map.getPlayingPlayers().size(), this.aiHelper));
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    public MinesweeperAI ai(MinesweeperPlayingPlayer player, Class<? extends MinesweeperAI> aiClass) {
        if (aiClass == null) {
            throw new IllegalArgumentException("AI class is null");
        }
        try {
            return aiClass.getConstructor(MinesweeperPlayingPlayer.class).newInstance(player);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public MapFactory withSize(int width, int height) {
        return new MapFactoryImpl(width, height);
    }

    public static MapFactory cleanFactory() {
        return new MapFactoryImpl(16, 16);
    }

    public MapFactory withPlugin(MinesweeperPlugin plugin) {
        this.map.addPlugin(plugin);
        return this;
    }

    public MapFactory withAI(Class<? extends MinesweeperAI> aiClass) {
        return this.withAI(aiClass, null);
    }

    public MapFactory withPlayer(MinesweeperPlayer player) {
        ((MfeMap)this.map).addPlayer(new MfePlayer(this.map, player, this.map.getPlayingPlayers().size()));
        return this;
    }
}

