/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.game.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.BaseEvent;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import org.apache.log4j.Logger;

public class EventHandler {
    private static Logger logger = Logger.getLogger((String)"Plugins");
    private final MinesweeperPlugin plugin;
    private final Annotation annotation;
    private Method method;
    private EventListener object;

    public EventListener getListener() {
        return this.object;
    }

    public EventHandler(MinesweeperPlugin plugin, EventListener listener, Method method, Annotation annotation) {
        this.plugin = plugin;
        this.annotation = annotation;
        this.method = method;
        this.object = listener;
    }

    public void execute(BaseEvent event) {
        try {
            this.method.invoke((Object)this.object, event);
        }
        catch (IllegalAccessException e1) {
            logger.error((Object)("Exception when performing EventHandler " + this.getPlugin().getSimpleName() + " for event " + event.toString()), (Throwable)e1);
        }
        catch (IllegalArgumentException e1) {
            logger.error((Object)("Exception when performing EventHandler " + this.getPlugin().getSimpleName() + " for event " + event.toString()), (Throwable)e1);
        }
        catch (InvocationTargetException e1) {
            if (event instanceof PlayerCommandEvent) {
                ((PlayerCommandEvent)event).getPlayer().sendAlert("Error handling command: " + e1.getCause().toString() + "\n" + UtilZomisUtils.implodeArr((String)"\n", (Object[])e1.getStackTrace()));
            }
            logger.error((Object)("Exception when performing EventHandler " + this.getPlugin().getSimpleName() + " for event " + event.toString()), (Throwable)e1);
        }
    }

    public String toString() {
        return "(" + this.plugin.getFullName() + ": " + this.method.getName() + ")";
    }

    public MinesweeperPlugin getPlugin() {
        return this.plugin;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }
}

