/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.game.model;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.zomis.minesweeper.api.Minesweeper;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.api.PluginHelper;
import net.zomis.minesweeper.events.BaseEvent;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.Event;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.game.GameEvent;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.game.model.EventHandler;
import org.apache.log4j.Logger;

public class MinesweeperEvents {
    private static final Logger logger = Logger.getLogger((String)"Plugins");
    private Map<Class<? extends BaseEvent>, Collection<EventHandler>> bindings = new HashMap<Class<? extends BaseEvent>, Collection<EventHandler>>();
    private Map<String, EventHandler> commands = new HashMap<String, EventHandler>();
    private static MinesweeperEvents eventHandler;

    public static Set<String> getRegistredCommands() {
        return new HashSet<String>(MinesweeperEvents.getCreate().commands.keySet());
    }

    public static EventHandler getCommand(String command) {
        return MinesweeperEvents.eventHandler.commands.get(command);
    }

    public MinesweeperEvents activatePlugin(MinesweeperPlugin plugin, PluginHelper helper, File file) {
        if (plugin.isEnabled()) {
            throw new IllegalArgumentException("Plugin " + plugin + " is already enabled");
        }
        plugin.initialize(Minesweeper.getServer(), helper, file);
        plugin.setEnabled(true);
        return this;
    }

    private MinesweeperEvents() {
        if (eventHandler != null) {
            throw new AssertionError((Object)("An instance of " + this.getClass().getSimpleName() + " already exists."));
        }
        eventHandler = this;
    }

    @Deprecated
    public static int getListenerCountFor(Class<? extends BaseEvent> clazz) {
        if (!MinesweeperEvents.eventHandler.bindings.containsKey(clazz)) {
            return 0;
        }
        return MinesweeperEvents.eventHandler.bindings.get(clazz).size();
    }

    public static boolean canHandleCommand(String command, MinesweeperPlayer user) {
        return MinesweeperEvents.eventHandler.commands.containsKey(command);
    }

    public static <T extends BaseEvent> T executeEvent(T event) {
        logger.debug((Object)("Execute Minesweeper Event: " + event + " (" + event.getClass().getCanonicalName() + ")"));
        if (MinesweeperEvents.getCreate() == null) {
            return event;
        }
        if (MinesweeperEvents.eventHandler.bindings == null) {
            return event;
        }
        Collection<EventHandler> handlers = null;
        if (!(event instanceof PlayerCommandEvent)) {
            if (!MinesweeperEvents.eventHandler.bindings.containsKey(event.getClass())) {
                return event;
            }
        } else {
            String command = ((PlayerCommandEvent)event).getCommand();
            EventHandler eh = MinesweeperEvents.eventHandler.commands.get(command);
            if (eh == null) {
                logger.info((Object)("No eventHandler for command: " + command));
                return event;
            }
            try {
                eh.execute(event);
            }
            catch (Exception e) {
                logger.error((Object)String.format("Error performing command %s in %s: %s", event.toString(), eh.toString(), e.getMessage()));
            }
            return event;
        }
        handlers = MinesweeperEvents.eventHandler.bindings.get(event.getClass());
        logger.debug((Object)("Handlers for event: " + handlers));
        for (EventHandler handler : handlers) {
            GameEvent g;
            if (handler == null || event instanceof GameEvent && !(g = (GameEvent)event).getMap().hasPlugin(handler.getPlugin())) continue;
            try {
                handler.execute(event);
            }
            catch (Exception e) {
                logger.error((Object)String.format("Error handling event %s in %s: %s", event.toString(), handler.toString(), e.getMessage()), (Throwable)e);
            }
        }
        return event;
    }

    public static MinesweeperEvents getCreate() {
        if (eventHandler == null) {
            eventHandler = new MinesweeperEvents();
        }
        return eventHandler;
    }

    public void registerListener(EventListener listener, MinesweeperPlugin plugin) {
        Method[] methods;
        logger.info((Object)("Register MFE event listener: " + listener));
        if (this.bindings == null) {
            throw new NullPointerException("No bindings on MinesweeperEvents has been created.");
        }
        for (Method method : methods = listener.getClass().getDeclaredMethods()) {
            Class<?>[] parameters;
            Event annotation = method.getAnnotation(Event.class);
            Command commandAnnotation = method.getAnnotation(Command.class);
            if (annotation == null && commandAnnotation == null || (parameters = method.getParameterTypes()).length != 1) continue;
            Class<?> param = parameters[0];
            if (!method.getReturnType().equals(Void.TYPE)) {
                logger.warn((Object)("Ignoring method due to non-void return: " + method.getName()));
                continue;
            }
            if (PlayerCommandEvent.class.isAssignableFrom(param)) {
                if (commandAnnotation == null) {
                    logger.error((Object)"PlayerCommandEvent should use the @Command annotation instead of the @Event annotation.");
                    continue;
                }
                if (this.commands.containsKey(commandAnnotation.command())) {
                    logger.error((Object)("Command " + commandAnnotation.command() + " was registred by " + this.commands.get(commandAnnotation.command()).getPlugin().getSimpleName() + ", cannot register " + method.getName() + " in " + plugin.getSimpleName()));
                    continue;
                }
                logger.info((Object)("Command: " + listener.getClass().getSimpleName() + " - " + method.getName() + " --> " + commandAnnotation.command()));
                EventHandler eh = new EventHandler(plugin, listener, method, (Annotation)commandAnnotation);
                this.commands.put(commandAnnotation.command(), eh);
                continue;
            }
            if (!BaseEvent.class.isAssignableFrom(param)) continue;
            Class<?> realParam = param;
            if (!this.bindings.containsKey(realParam)) {
                this.bindings.put(realParam, new HashSet());
            }
            Collection<EventHandler> set = this.bindings.get(realParam);
            logger.info((Object)("Add listener method: " + method.getName() + " for event " + realParam.getSimpleName()));
            EventHandler eh = new EventHandler(plugin, listener, method, (Annotation)annotation);
            set.add(eh);
        }
    }

    public static void removeListenerFromBindings(EventListener listener) {
        for (Map.Entry<Class<? extends BaseEvent>, Collection<EventHandler>> ee : MinesweeperEvents.eventHandler.bindings.entrySet()) {
            Iterator<EventHandler> it = ee.getValue().iterator();
            while (it.hasNext()) {
                EventHandler eh = it.next();
                if (eh.getListener() != listener) continue;
                it.remove();
            }
        }
    }

    public static void clearListeners() {
        MinesweeperEvents.eventHandler.bindings.clear();
        MinesweeperEvents.eventHandler.commands.clear();
    }

    @Deprecated
    public static boolean pluginListensForEvent(MinesweeperPlugin plugin, Class<?> eventClass) {
        if (!MinesweeperEvents.eventHandler.bindings.containsKey(eventClass)) {
            return false;
        }
        Collection<EventHandler> coll = MinesweeperEvents.eventHandler.bindings.get(eventClass);
        for (EventHandler eh : coll) {
            if (!eh.getPlugin().equals(plugin)) continue;
            return true;
        }
        return false;
    }
}

