package net.zomis.minesweeper.game.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import net.zomis.minesweeper.api.AIHelper;
import net.zomis.minesweeper.api.MinesweeperAI;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class MfeAI extends MfePlayer implements MinesweeperPlayingPlayer {
	public static final int DEFAULT_DELAY = 300;
	
	private final MinesweeperAI ai;

	public MfeAI(MinesweeperMap map, MinesweeperPlayer player, Constructor<? extends MinesweeperAI> constructor, int index, AIHelper aiHelper)
			throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
		super(map, player, index);
		this.ai = constructor.newInstance(this);
		this.ai.init(aiHelper);
	}
	@Override
	public String getName() {
		return this.ai.getName();
	}
	
	@Override
	public MinesweeperAI getAI() {
		return this.ai;
	}
	
	@Override
	public boolean isAI() {
		return true;
	}
	
	@Override
	public void eliminate(final int resultPosition) {
		super.eliminate(resultPosition);
		
		final MfeMap map = (MfeMap) this.getMap();
		// TODO: Perform onWin and onLose always for AIs, but ignore any thread sleeps if there's no AI Timer.
		// TODO: Annotations in AIs for different methods. Such as @AIGameEnd. @AICommand, @AIChatReply
		// TODO: Move onWin and onLose code to server plugin
		
//		if (map.aiTimer != null) {
//			new Thread(new Runnable() {
//				@Override
//				public void run() {
//					try {
//						if (resultPosition <= 1)
//							MfeAI.this.ai.onWin();
//						else MfeAI.this.ai.onLose();
//					} catch (InterruptedException e) {
//						e.printStackTrace();
//					}
//					map.removePlayer(MfeAI.this);
//				}
//			}).start();
//		}
//		else {
			map.removePlayer(this);
//		}
	}
}
