package net.zomis.minesweeper.game.model;

import java.util.ArrayList;
import java.util.List;

import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.api.MapFactory;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.game.MinesweeperReplay;

public class MapUtils {
	public static List<String> getRealMap(MinesweeperMap map) {
		// TODO: use CharMapPrint method
		List<String> result = new ArrayList<String>();
		for (MinesweeperPlayingPlayer player : map.getPlayingPlayers()) {
			result.add("Player " + player.getIndex() + ": " + player.getName() + " (" + player.getScore() + ")");
		}
		for (int y = 0; y < map.getFieldHeight(); y++) {
			String line = "";
			for (int x = 0; x < map.getFieldWidth(); x++) {
				MinesweeperField mf = map.getPosition(x, y);
				line += charForField(mf);
			}
			result.add(line);
		}
		result.add("Mines left: " + map.getMinesLeft());
		
		return result;
	}
	public static String[] getKnownMap(MinesweeperMap map) {
		// TODO: use CharMapPrint method
		
		String[] result = new String[map.getFieldHeight()];
		
		String str = "";
		for (MinesweeperField mf : map.getIteration()) {
			if (mf.getX() == 0) {
				if (mf.getY() > 0) result[mf.getY() - 1] = str;
				str = "";
			}
			str += mf.isClicked() ? charForField(mf) : " ";
		}
		result[map.getFieldHeight() - 1] = str;
		return result;
	}

	public static String getMinesString(MinesweeperMap map) {
		String str = "";
		for (int xx = 0; xx < map.getFieldWidth(); xx++)
		for (int yy = 0; yy < map.getFieldWidth(); yy++) {
			MinesweeperField field = map.getPosition(xx, yy);
			if (field.isMine()) {
				str += field.getCoordinate();
			}
		}
		return str;
	}

	public static String getClickString(MinesweeperMap map) {
		String clicks = "";
		for (MinesweeperMove move : map.getMoveHistory()) {
			clicks += move.getMoveString();
		}
		return clicks;
	}
	public static char charForField(MinesweeperField field) {
		if (field.isBlocked()) return '#';
		if (field.isMine()) return '*';
		
		return String.valueOf(field.getValue()).charAt(0);
	}
	public static String saveKnownMap(MinesweeperMap map) {
		return map.saveMap().replace("x", "_");
	}
	public static MinesweeperMap copyBase(MinesweeperMap map) {
		MapFactory mmap = map.getMapFactory().withSize(map.getFieldWidth(), map.getFieldHeight());
		for (MinesweeperPlugin plugin : map.getActivePlugins()) {
			mmap = mmap.withPlugin(plugin);
		}
		mmap = mmap.withPlayers(map.getPlayingPlayers().size());
		return mmap.map();
	}
	public static MinesweeperMap copyMap(MinesweeperMap map) {
		if (map.getMoveHistory().isEmpty()) {
			MinesweeperMap copy = copyBase(map);
			return copy.loadMap(map.saveMap());
		}
		
		// To perserve wether or not weapons has been used, create a replay!
		MinesweeperReplay replay = map.createReplay();
		UtilZomisUtils.echo(replay + " moves " + replay.getMoveCount());
		UtilZomisUtils.echo(replay.getMap().saveMap());
		replay.setPosition(replay.getMoveCount() + 1);
		UtilZomisUtils.echo(replay.getMap().saveMap());
		return replay.getMap();
	}
}
