package net.zomis.minesweeper.game.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.BaseEvent;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;

import org.apache.log4j.Logger;


public class EventHandler {
	private static Logger logger = Logger.getLogger("Plugins");
	
	private final MinesweeperPlugin plugin;
	private final Annotation annotation;
	private Method	method;
	private EventListener object;
	public EventListener getListener() {
		return object;
	}

	public EventHandler(MinesweeperPlugin plugin, EventListener listener, Method method, Annotation annotation) {
		this.plugin = plugin;
		this.annotation = annotation;
		this.method = method;
		this.object = listener;
	}

	public void execute(BaseEvent event) {
		try {
			method.invoke(object, event);
		} catch (IllegalAccessException e1) {
			logger.error("Exception when performing EventHandler " + this.getPlugin().getSimpleName() + " for event " + event.toString(), e1);
		} catch (IllegalArgumentException e1) {
			logger.error("Exception when performing EventHandler " + this.getPlugin().getSimpleName() + " for event " + event.toString(), e1);
		} catch (InvocationTargetException e1) {
			if (event instanceof PlayerCommandEvent) {
				((PlayerCommandEvent) event).getPlayer().sendAlert("Error handling command: " + e1.getCause().toString() + "\n" + UtilZomisUtils.implodeArr("\n", e1.getStackTrace()));
			}

			logger.error("Exception when performing EventHandler " + this.getPlugin().getSimpleName() + " for event " + event.toString(), e1);
		} 
	}
	@Override
	public String toString() {
		return "(" + plugin.getFullName() + ": " + method.getName() + ")";
	}

	public MinesweeperPlugin getPlugin() {
		return plugin;
	}

	public Annotation getAnnotation() {
		return annotation;
	}
}
