package net.zomis.minesweeper.weapons.classic;

import java.util.ArrayList;
import java.util.Collection;

import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.functional.Supplier;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.weapons.BaseWeapon;
import net.zomis.minesweeper.weapons.LimitedUseWeapon;

public class BombWeapon extends LimitedUseWeapon {

    public static final Supplier<BombWeapon> supplier = new Supplier<BombWeapon>() {
        @Override
        public BombWeapon get() {
            return new BombWeapon(1);
        }
    };

    public static final int RANGE = 2;

    public BombWeapon(int useCount) {
        super(useCount);
    }

    @Deprecated
	public int getUseCount() {
		return this.getInitialRemainingUses() - getUsesRemaining();
	}

    @Override
	public String getWeaponType() {
		return MinesweeperMove.STANDARD_BOMB;
	}

	@Override
	public boolean canUseAt(MinesweeperPlayingPlayer user, MinesweeperField field) {
		Collection<MinesweeperField> affected = this.getFieldsAffected(user, field);
		if (affected == null) return false;
		return affected.size() > 0;
	}

	protected MinesweeperField getMove(MinesweeperPlayingPlayer user, MinesweeperField field) {
		int xpos = UtilZomisUtils.ensureRange(RANGE, field.getX(), field.getMap().getFieldWidth() - RANGE - 1);
		int ypos = UtilZomisUtils.ensureRange(RANGE, field.getY(), field.getMap().getFieldHeight() - RANGE - 1);
		return field.getMap().getPosition(xpos, ypos);
	}
	
	@Override
	public Collection<MinesweeperField> getFieldsAffected(MinesweeperPlayingPlayer user, MinesweeperField field) {
		field = getMove(user, field);
		
		ArrayList<MinesweeperField> result = new ArrayList<MinesweeperField>();
		for (MinesweeperField mf : this.getFieldsWithinRange(field, BombWeapon.RANGE)) {
			if (!mf.isClicked()) result.add(mf);
		}
		
		return result;
	}

    @Override
    public boolean allowedUse(MinesweeperPlayingPlayer user) {
        return !user.hasMostScore();
    }

    @Override
    protected boolean performUse(MinesweeperMove moveInfo) {
        if (!this.canUseAt(moveInfo.getPlayer(), moveInfo.getMovePosition())) return false;

//		moveInfo.getMovePosition()
        MinesweeperMove move = moveInfo.getPlayer().createMove(this, this.getMove(moveInfo.getPlayer(), moveInfo.getMovePosition()));
        for (MinesweeperField mf : this.getFieldsAffected(moveInfo.getPlayer(), move.getMovePosition())) {
            this.expanderOpen(mf, move);
        }
        moveInfo.getMap().nextTurn();
        return true;
    }

    @Override
	public String toString() {
		return (this.getUsesRemaining() == 0 ? "USED " : "Unused ") + super.toString();
	}

}
