package net.zomis.minesweeper.classic;

import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.game.GameInitEvent;
import net.zomis.minesweeper.functional.Consumer;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.weapons.classic.BombWeapon;
import net.zomis.minesweeper.weapons.classic.ClickWeapon;

public class StandardWeapons implements EventListener, Consumer<GameInitEvent> {
	@Override
	public void accept(GameInitEvent event) {
		for (MinesweeperPlayingPlayer player : event.getMap().getPlayingPlayers()) {
			player.giveWeapon(new ClickWeapon());
			player.giveWeapon(new BombWeapon(1));
		}
	}
}
