package net.zomis.minesweeper.api;

import net.zomis.minesweeper.api.ai.AIHelper;
import net.zomis.minesweeper.api.ai.AISupplier;
import net.zomis.minesweeper.api.ai.MinesweeperAI;
import net.zomis.minesweeper.events.EventRegistrator;
import net.zomis.minesweeper.functional.Supplier;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public interface MapFactory {

	MapFactory loadFrom(String map);

	MinesweeperMap map();

	MapFactory setAIHelper(AIHelper aiHelper);

	MapFactory withDefaultWeapons();

	MinesweeperMap standard();

	MapFactory withWeapon(Supplier<? extends MinesweeperWeapon> weapon);
	
	MapFactory withPlugin(MinesweeperPlugin plugin);
	
	/**
	 * Creates a new map factory with the specified size. Erases all previous configurations of the map factory.
	 * 
	 * @param width The width of the map
	 * @param height The height of the map
	 * @return A new map factory with the specified size.
	 */
	MapFactory withSize(int width, int height);

	MapFactory withTwoPlayers();

	MapFactory withPlayers(int count);
	/**
	 * Get an AI instance representing an existing player.
	 * @param player The player to represent
	 * @param aiSupplier The AI to create
	 * @return An instance of the class specified by aiClass that is linked to the specified player
	 */
    @Deprecated
	MinesweeperAI ai(MinesweeperPlayingPlayer player, AISupplier aiSupplier);

	MinesweeperMap hiddenMap(MinesweeperMap map);

	MapFactory withAI(AISupplier aiClass, MinesweeperPlayer backingPlayer);
	MapFactory withAI(AISupplier aiClass);
	
	MapFactory withPlayer(MinesweeperPlayer player);

	MapFactory withEvents(EventRegistrator events);
	
}
