package net.zomis.minesweeper.events.game;

import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
/**
 * Called when a player's score has changed.
 */
public class GameScoreChanged extends PlayerGameEvent {
	private final int oldScores;
	private final int scoreChange;
	
	public GameScoreChanged(MinesweeperMap game, MinesweeperPlayingPlayer whosScoreChanged, int oldScore) {
		super(game, whosScoreChanged);
		this.oldScores = oldScore;
		this.scoreChange = whosScoreChanged.getScore() - oldScore;
	}
	
	public int getPreviousScore() {
		return oldScores;
	}
	
	public int getScoreChange() {
		return this.scoreChange;
	}
	
	@Deprecated
	public MinesweeperPlayingPlayer getWhoChanged() {
		return this.getPlayingPlayer();
	}

	@Override
	public String toString() {
		return "GameScoreChanged: " + getMap() + " - " + getPlayingPlayer() +
                " oldScore was " + oldScores + " scoreChange " + scoreChange;
	}
}
