package net.zomis.minesweeper.events.game;

import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperGame;
/**
 * Fired when an observer is clicking in the observed game.
 */
public class ObserverClickEvent extends PlayerGameEvent {

	private final MinesweeperField field;

	public ObserverClickEvent(MinesweeperGame game, MinesweeperPlayer player, MinesweeperField field) {
		super(game, player);
		this.field = field;
	}
	
	public MinesweeperField getField() {
		return field;
	}

}
