package net.zomis.minesweeper.weapons;

import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public abstract class LimitedUseWeapon extends BaseWeapon {

    private final int initialRemainingUses;
    private int remainingUses;

    public LimitedUseWeapon(int useCount) {
        this.initialRemainingUses = useCount;
        this.remainingUses = initialRemainingUses;
    }

    @Override
    public final boolean canUse(MinesweeperPlayingPlayer user) {
        return remainingUses > 0 && allowedUse(user);
    }

    public abstract boolean allowedUse(MinesweeperPlayingPlayer user);

    @Override
    public int getUsesRemaining() {
        return remainingUses;
    }

    @Override
    public final boolean useAt(MinesweeperMove moveInfo) {
        if (!this.canUseAt(moveInfo.getPlayer(), moveInfo.getMovePosition())) {
            return false;
        }

        boolean useOK = performUse(moveInfo);
        if (useOK && remainingUses > 0) {
            remainingUses--;
        }
        return useOK;
    }

    protected abstract boolean performUse(MinesweeperMove moveInfo);

    @Override
    public void resetUsage() {
        this.remainingUses = this.initialRemainingUses;
    }

    public int getInitialRemainingUses() {
        return initialRemainingUses;
    }

}
