package net.zomis.minesweeper.events.game.server;

import net.zomis.minesweeper.events.CancellableEvent;
import net.zomis.minesweeper.events.game.GameEvent;
import net.zomis.minesweeper.game.MinesweeperGame;
/**
 * Called very early in the process of starting a game to allow plugins to cancel this game.<br>
 * Example reasons to cancel could be rating difference between players, player not allowed to play special kinds of games, all AIs disabled, etc.
 * 
 * Is only called on server.
 */
public class GamePreStartEvent extends GameEvent implements CancellableEvent {

	public GamePreStartEvent(MinesweeperGame game) {
		super(game);
	}
	
	// Cancelled implementation
	private boolean cancelled;
	public boolean isCancelled() {
		return this.cancelled;
	}
	public void setCancelled(boolean cancel) {
		this.cancelled = cancel;
	}
}
