package net.zomis.minesweeper.events.player;

import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMap;
/**
 * Called when a command is called.
 *
 * <b>Implementing your own commands should use this event and the {@link Command} annotation</b><br>
 * This event can also be used to send more information when a player writes /info for example.
 */
public class PlayerCommandEvent extends PlayerEvent {
	public static final String PERMISSION_TESTER = "TESTER";
	public static final String PERMISSION_MODERATOR = "MODERATOR";
	public static final String PERMISSION_TRUSTED_USER = "TRUSTED";
	public static final String PERMISSION_ADMIN = "ADMIN";
	public static final String PERMISSION_DONATOR	= "DONATOR";
	
	private final String command;
	private final String[] parameters;
	public PlayerCommandEvent(MinesweeperPlayer player, String command) {
		super(player);
		if (!command.contains(" ")) 
			command += " ";
		this.command = command.substring(0, command.indexOf(" "));
		command = command.substring(this.command.length() + 1);
		this.parameters = command.split(" ");
	}
	
	public PlayerCommandEvent(MinesweeperPlayer player, String command, String[] parameters) {
		super(player);
		this.command = command;
		this.parameters = parameters;
	}

	public String getCommand() {
		return command;
	}

	public String[] getParameters() {
		return parameters;
	}
	public String getParameter(int i) {
		if (this.parameters.length > i) return this.parameters[i];
		return "";
	}
	public int getParameterInt(int i, int defaultValue) {
		try {
			return Integer.parseInt(getParameter(i));
		}
		catch (NumberFormatException e) {
			return defaultValue;
		}
	}
	public String getFullCommand() {
		return UtilZomisUtils.implode(" ", parameters);
	}
	public MinesweeperGame getGame() {
		if (this.getPlayer() == null) return null;
		return this.getPlayer().getGame();
	}
	public MinesweeperMap getMap() {
		if (this.getPlayer() == null) return null;
		return this.getPlayer().getMap();
	}
	
	@Override
	public String toString() {
		return "PlayerCommandEvent: " + getPlayer() + " /" + getCommand() + " " + getFullCommand();
	}

	// Cancelled implementation
	private boolean cancelled;
	public boolean isCancelled() {
		return this.cancelled;
	}
	public void setCancelled(boolean cancel) {
		this.cancelled = cancel;
	}
}
