package net.zomis.minesweeper.events.game;

import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.game.MinesweeperGame;
/**
 * Fired when a player needs to reload the entire game data.<br>
 * By default, the player will see the actual gamestate. Listen for this event to make the player see whatever you want to see.
 * 
 * Can be fired for both players and observers.
 */
public class PlayerReloadGameEvent extends PlayerGameEvent {

	public PlayerReloadGameEvent(MinesweeperGame game, MinesweeperPlayer player) {
		super(game, player);
	}
}
