package net.zomis.minesweeper.classic;

import java.util.List;
import java.util.Random;

import net.zomis.UtilZomisList;
import net.zomis.minesweeper.events.game.GamePreGenerateEvent;
import net.zomis.minesweeper.functional.Consumer;
import net.zomis.minesweeper.game.MinesweeperField;

public class StandardNeighbors {

    public static Consumer<GamePreGenerateEvent> classicNeighbors = new Consumer<GamePreGenerateEvent>() {
        @Override
        public void accept(GamePreGenerateEvent event) {
            for (MinesweeperField mf : event.getMap().getIteration()) {
                mf.addNeighbor(-1, -1);
                mf.addNeighbor(-1, 0);
                mf.addNeighbor(-1, 1);
                mf.addNeighbor(0, -1);
                mf.addNeighbor(0, 1);
                mf.addNeighbor(1, -1);
                mf.addNeighbor(1, 0);
                mf.addNeighbor(1, 1);
            }
		}
	};
	
//	@Event
	public void onRandomNeighbors(GamePreGenerateEvent event) {
		
		for (MinesweeperField mf : event.getMap().getIteration()) {
			List<MinesweeperField> all = event.getMap().getAllUnclickedFields();
			all.remove(mf);
			for (int i = 0; i < 8; i++) {
				mf.addNeighbor(UtilZomisList.getRandom(all));
			}
		}
	}
	
//	@Event
	public void onRotationSymmetryNeighbors(GamePreGenerateEvent event) {
		int[] xys = new int[4];
		int MAX_RANDOM = 3;
		Random rand = new Random();
		for (int i = 0; i < xys.length; i++) {
			xys[i] = rand.nextInt(MAX_RANDOM);
			if (event.getGame() != null) event.getGame().getServer().log("Random xys[" + i + "] = " + xys[i]);
		}
		
		for (MinesweeperField mf : event.getMap().getIteration()) {
			mf.addNeighbor(xys[0], xys[1]);
			mf.addNeighbor(xys[2], xys[3]);
			mf.addNeighbor(xys[0], -xys[1]);
			mf.addNeighbor(xys[2], -xys[3]);
			
			mf.addNeighbor(-xys[0], xys[1]);
			mf.addNeighbor(-xys[2], xys[3]);
			mf.addNeighbor(-xys[0], -xys[1]);
			mf.addNeighbor(-xys[2], -xys[3]);
			
		}
	}
}
