package net.zomis.minesweeper.classic;

import java.util.List;

import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.game.CustomEvent;
import net.zomis.minesweeper.events.game.PlayerAfterMoveEvent;
import net.zomis.minesweeper.functional.Consumer;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class DefaultExpanderRule implements EventListener, Consumer<PlayerAfterMoveEvent> {
	public static final String METADATA_KEY = "ExpanderRule";

	@Override
	public void accept(PlayerAfterMoveEvent event) {
		if (event.getMap().getMinesCount() != event.getMap().getMinesLeft()) return; // if any mine has been found, do nothing
		if (!event.getMove().getWeaponType().contentEquals(MinesweeperMove.STANDARD_CLICK)) return; // if the weapon was not standard click, do nothing
		
		for (MinesweeperPlayingPlayer pp : event.getMap().getPlayingPlayers()) {
			if (pp.getName().contentEquals("#AI_Loser")) return; // Expander rule ignored in games including AI Loser.
			if (pp.getName().contentEquals("AI_Loser")) return; // Expander rule ignored in games including AI Loser.
		}
		
		if (event.getGame() != null && event.getGame().getMetadata().get(METADATA_KEY) != null)
			return;
		
		if (event.getMove().getMovePosition().getValue() == 0) {
			// TODO: ExpanderRuleEvent (extends GameEvent implements CancellableEvent), execute that event and check if it was cancelled.
			if (event.getMap().executeCustomEvent(new CustomEvent(event.getMap(), METADATA_KEY)).isCancelled()) {
				return;
			}
			
			List<MinesweeperField> unclicked = event.getMap().getAllUnclickedFields();
			for (MinesweeperField field : event.getMap().getIteration()) {
				if (!unclicked.contains(field)) {
					field.inactivate();
					field.sendInfoToPlayers();
				}
			}
			
			event.getMap().generate();

			if (event.getGame() != null) 
				event.getGame().sendChatMessage("#Server: Expander rule applied! (An open field was found before a mine. Recreated board)", 0xff8000);
			else for (MinesweeperPlayingPlayer pp : event.getMap().getPlayingPlayers()) {
				if (pp.getPlayer() != null)
					pp.getPlayer().sendChat("#Server: Expander rule applied! (An open field was found before a mine. Recreated board)", 0xff8000);
			}
		}
		
		if (event.getMap().getCurrentPlayer().isAI()) 
			event.getMap().callAI();
	}
}
