package net.zomis.minesweeper.events.invites;

import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.events.BaseEvent;
import net.zomis.minesweeper.events.CancellableEvent;

public class InviteAddPlayerEvent extends BaseEvent implements CancellableEvent {
	private final Invite invite;
	private final MinesweeperPlayer player;
	
	public InviteAddPlayerEvent(Invite invite, MinesweeperPlayer player) {
		this.invite = invite;
		this.player = player;
	}

	public Invite getInvite() {
		return invite;
	}
	
	public MinesweeperPlayer getAddPlayer() {
		return player;
	}
	
	// Cancelled implementation
	private boolean cancelled;
	public boolean isCancelled() {
		return this.cancelled;
	}
	public void setCancelled(boolean cancel) {
		this.cancelled = cancel;
	}

}