package net.zomis.minesweeper.classic;

import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.game.GameEndedEvent;
import net.zomis.minesweeper.functional.Consumer;
import net.zomis.minesweeper.game.MinesweeperField;

public class EndShowMines implements EventListener, Consumer<GameEndedEvent> {

	@Override
	public void accept(GameEndedEvent event) {
		for (MinesweeperField mf : event.getMap().getIteration()) {
			if (mf.isClicked()) continue;
			if (!mf.isMine()) continue;
			
			mf.activate();
		}
	}

}
