package net.zomis.minesweeper.api;

public final class Minesweeper {
	public static final String URL_STATS = "http://stats.minesweeperflags.net";
	public static final String URL = "http://www.minesweeperflags.net";
	
	private static MinesweeperServer server = null;
	private static FactoryProvider factory = null;

	public final static MinesweeperServer getServer() {
		return Minesweeper.server;
	}
	public final static void setServer(MinesweeperServer server) {
		if (Minesweeper.server != null) throw new IllegalStateException("Variable is already set.");
		Minesweeper.server = server;
	}
	public final static void setFactory(FactoryProvider factory) {
		if (Minesweeper.factory != null) throw new IllegalStateException("Variable is already set.");
		Minesweeper.factory = factory;
	}
	public final static MapFactory getMapFactory() {
		return factory.getMapFactory();
	}
}
