package net.zomis.minesweeper.weapons.classic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import net.zomis.minesweeper.functional.Supplier;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.weapons.BaseWeapon;

public class ClickWeapon extends BaseWeapon {

    public static final Supplier<ClickWeapon> supplier = new Supplier<ClickWeapon>() {
        @Override
        public ClickWeapon get() {
            return new ClickWeapon();
        }
    };

	@Override
	public String getWeaponType() {
		return MinesweeperMove.STANDARD_CLICK;
	}

	@Override
	public boolean canUse(MinesweeperPlayingPlayer user) {
		return true;
	}

	@Override
	public boolean canUseAt(MinesweeperPlayingPlayer user, MinesweeperField field) {
		Collection<MinesweeperField> affected = this.getFieldsAffected(user, field);
		if (affected == null) return false;
		return affected.size() > 0;
	}

	@Override
	public Collection<MinesweeperField> getFieldsAffected(MinesweeperPlayingPlayer user, MinesweeperField field) {
		if (field == null) throw new NullPointerException(this + " field is null.");
		
		List<MinesweeperField> result = new ArrayList<MinesweeperField>();
		if (!field.isClicked()) result.add(field);
		return result;
	}

	@Override
	public boolean useAt(MinesweeperMove moveInfo) {
		if (!this.canUseAt(moveInfo.getPlayer(), moveInfo.getMovePosition())) return false;
		
		this.expanderOpen(moveInfo.getMovePosition(), moveInfo);
		
		if (!moveInfo.getMovePosition().isMine()) moveInfo.getMap().nextTurn();
		return true;
	}

	@Override
	public void resetUsage() {
	}
}
