package net.zomis.minesweeper.events.game;

import net.zomis.minesweeper.events.CancellableEvent;
import net.zomis.minesweeper.game.MinesweeperMove;
/**
 * Called when a player is about to make his move, giving plugins a chance to cancel it<br>
 * Canceling an AI's move is not recommended.
 */
public final class PlayerMoveEvent extends PlayerGameEvent implements CancellableEvent {
	private MinesweeperMove move;

	public PlayerMoveEvent(MinesweeperMove move) {
		super(move.getMap(), move.getPlayer());
		this.move = move;
	}
	public MinesweeperMove getMove() {
		return this.move;
	}
	
	// Cancelled implementation
	private boolean cancelled;
	public boolean isCancelled() {
		return this.cancelled;
	}
	public void setCancelled(boolean cancel) {
		this.cancelled = cancel;
	}

}

