package net.zomis.minesweeper.events.game;

import net.zomis.minesweeper.api.ai.MinesweeperAI;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class AIExceptionEvent extends PlayerGameEvent {
	private final Throwable exception;
	private final MinesweeperMove move;
	private final MinesweeperAI ai;

	public AIExceptionEvent(MinesweeperAI theAI, MinesweeperPlayingPlayer player, MinesweeperMove move, Throwable e, MinesweeperMap map) {
		super(map, player);
		this.exception = e;
		this.move = move;
		this.ai = theAI;
	}

	public Throwable getException() {
		return exception;
	}

	public MinesweeperMove getMove() {
		return move;
	}

	public MinesweeperAI getAI() {
		return ai;
	}
}
